# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from iblai.models.notification_source import NotificationSource
from iblai.models.notification_template_data import NotificationTemplateData
from typing import Optional, Set
from typing_extensions import Self

class NotificationPreview(BaseModel):
    """
    Request serializer for notification preview
    """ # noqa: E501
    template_id: Optional[UUID] = Field(default=None, description="Use a predefined template in the system")
    template_data: Optional[NotificationTemplateData] = Field(default=None, description="Specify this to send a new custom message without using a predefined template")
    channels: List[StrictInt] = Field(description="Specify the channel ids to send notifications to.")
    sources: List[NotificationSource] = Field(description="Specify the sources to send notifications to")
    context: Optional[Dict[str, Any]] = Field(default=None, description="Specify the context that would be available in the message text")
    process_on: Optional[datetime] = Field(default=None, description="(ISO datetime) Specify the date and time of processing this notification. Note, notifications are sent hourly and only scheduled messages prior to the beginning of the hour would be sent")
    __properties: ClassVar[List[str]] = ["template_id", "template_data", "channels", "sources", "context", "process_on"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationPreview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of template_data
        if self.template_data:
            _dict['template_data'] = self.template_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sources (list)
        _items = []
        if self.sources:
            for _item_sources in self.sources:
                if _item_sources:
                    _items.append(_item_sources.to_dict())
            _dict['sources'] = _items
        # set to None if template_id (nullable) is None
        # and model_fields_set contains the field
        if self.template_id is None and "template_id" in self.model_fields_set:
            _dict['template_id'] = None

        # set to None if template_data (nullable) is None
        # and model_fields_set contains the field
        if self.template_data is None and "template_data" in self.model_fields_set:
            _dict['template_data'] = None

        # set to None if process_on (nullable) is None
        # and model_fields_set contains the field
        if self.process_on is None and "process_on" in self.model_fields_set:
            _dict['process_on'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationPreview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "template_id": obj.get("template_id"),
            "template_data": NotificationTemplateData.from_dict(obj["template_data"]) if obj.get("template_data") is not None else None,
            "channels": obj.get("channels"),
            "sources": [NotificationSource.from_dict(_item) for _item in obj["sources"]] if obj.get("sources") is not None else None,
            "context": obj.get("context"),
            "process_on": obj.get("process_on")
        })
        return _obj


