# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.consumer_channel import ConsumerChannel
from iblai.models.periodic_frequency_enum import PeriodicFrequencyEnum
from iblai.models.periodic_learner_scope_enum import PeriodicLearnerScopeEnum
from iblai.models.spa import Spa
from typing import Optional, Set
from typing_extensions import Self

class NotificationTemplateDetail(BaseModel):
    """
    Serializer for detailed template view and editing
    """ # noqa: E501
    id: UUID = Field(description="Unique identifier for this notification template.")
    type: Optional[StrictStr] = Field(description="Select the type of notification from the available options.  * `DEFAULT_TEMPLATE` - Default Template * `APP_REGISTRATION` - App Registration * `USER_NOTIF_USER_REGISTRATION` - User Notif User Registration * `USER_NOTIF_COURSE_ENROLLMENT` - User Notif Course Enrollment * `ADMIN_NOTIF_COURSE_ENROLLMENT` - Admin Notif Course Enrollment * `USER_NOTIF_USER_INACTIVITY` - User Notif User Inactivity * `USER_NOTIF_COURSE_COMPLETION` - User Notif Course Completion * `USER_NOTIF_CREDENTIALS` - User Notif Credentials * `CUSTOM_NOTIFICATION` - Custom Notification * `PLATFORM_INVITATION` - Platform Invitation * `PROGRAM_INVITATION` - Program Invitation * `COURSE_INVITATION` - Course Invitation * `USER_NOTIF_LEARNER_PROGRESS` - User Notif Learner Progress * `PROACTIVE_LEARNER_NOTIFICATION` - Proactive Learner Notification * `ROLE_CHANGE` - Role Change * `COURSE_LICENSE_ASSIGNMENT` - Course License Assignment * `COURSE_LICENSE_GROUP_ASSIGNMENT` - Course License Group Assignment * `PROGRAM_LICENSE_ASSIGNMENT` - Program License Assignment * `PROGRAM_LICENSE_GROUP_ASSIGNMENT` - Program License Group Assignment * `USER_LICENSE_ASSIGNMENT` - User License Assignment * `USER_LICENSE_GROUP_ASSIGNMENT` - User License Group Assignment")
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="A friendly name for the notification template.")
    description: Optional[StrictStr] = Field(default=None, description="Admin-friendly description of what this notification does, when it triggers, and what data it needs")
    message_title: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The title for the notification message.")
    message_body: Optional[StrictStr] = Field(default=None, description="The full notification message body.")
    short_message_body: Optional[StrictStr] = Field(default=None, description="A short version of the notification message body.")
    email_subject: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Email subject line (supports Django template syntax)")
    email_from_address: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Sender email address (default: IBL <noreply@ibl.ai>)")
    email_html_template: Optional[StrictStr] = Field(default=None, description="Full HTML template for email body")
    spas_detail: List[Spa]
    allowed_channels_detail: List[ConsumerChannel]
    spa_ids: Optional[List[StrictInt]] = None
    channel_ids: Optional[List[StrictInt]] = None
    is_inherited: StrictBool
    is_enabled: StrictBool
    source_platform: StrictStr
    metadata: Optional[Any] = None
    available_context: StrictStr
    proactive_prompt_message: Optional[StrictStr] = Field(default=None, description="Default prompt message for AI mentor notifications")
    periodic_config: StrictStr
    periodic_learner_scope: Optional[PeriodicLearnerScopeEnum] = None
    periodic_report_period_days: Optional[Annotated[int, Field(le=365, strict=True, ge=1)]] = None
    periodic_frequency: Optional[PeriodicFrequencyEnum] = None
    periodic_custom_interval_days: Optional[Annotated[int, Field(le=365, strict=True, ge=1)]] = None
    periodic_execution_time: Optional[StrictStr] = None
    periodic_timezone: Optional[StrictStr] = None
    periodic_mentors: Optional[List[Dict[str, Any]]] = Field(default=None, description="List of mentor configurations: [{\"unique_id\": \"uuid\", \"prompt\": \"...\", \"name\": \"...\"}]")
    created_at: datetime = Field(description="Timestamp when this template was created")
    updated_at: datetime = Field(description="Timestamp when this template was last updated")
    __properties: ClassVar[List[str]] = ["id", "type", "name", "description", "message_title", "message_body", "short_message_body", "email_subject", "email_from_address", "email_html_template", "spas_detail", "allowed_channels_detail", "spa_ids", "channel_ids", "is_inherited", "is_enabled", "source_platform", "metadata", "available_context", "proactive_prompt_message", "periodic_config", "periodic_learner_scope", "periodic_report_period_days", "periodic_frequency", "periodic_custom_interval_days", "periodic_execution_time", "periodic_timezone", "periodic_mentors", "created_at", "updated_at"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DEFAULT_TEMPLATE', 'APP_REGISTRATION', 'USER_NOTIF_USER_REGISTRATION', 'USER_NOTIF_COURSE_ENROLLMENT', 'ADMIN_NOTIF_COURSE_ENROLLMENT', 'USER_NOTIF_USER_INACTIVITY', 'USER_NOTIF_COURSE_COMPLETION', 'USER_NOTIF_CREDENTIALS', 'CUSTOM_NOTIFICATION', 'PLATFORM_INVITATION', 'PROGRAM_INVITATION', 'COURSE_INVITATION', 'USER_NOTIF_LEARNER_PROGRESS', 'PROACTIVE_LEARNER_NOTIFICATION', 'ROLE_CHANGE', 'COURSE_LICENSE_ASSIGNMENT', 'COURSE_LICENSE_GROUP_ASSIGNMENT', 'PROGRAM_LICENSE_ASSIGNMENT', 'PROGRAM_LICENSE_GROUP_ASSIGNMENT', 'USER_LICENSE_ASSIGNMENT', 'USER_LICENSE_GROUP_ASSIGNMENT']):
            raise ValueError("must be one of enum values ('DEFAULT_TEMPLATE', 'APP_REGISTRATION', 'USER_NOTIF_USER_REGISTRATION', 'USER_NOTIF_COURSE_ENROLLMENT', 'ADMIN_NOTIF_COURSE_ENROLLMENT', 'USER_NOTIF_USER_INACTIVITY', 'USER_NOTIF_COURSE_COMPLETION', 'USER_NOTIF_CREDENTIALS', 'CUSTOM_NOTIFICATION', 'PLATFORM_INVITATION', 'PROGRAM_INVITATION', 'COURSE_INVITATION', 'USER_NOTIF_LEARNER_PROGRESS', 'PROACTIVE_LEARNER_NOTIFICATION', 'ROLE_CHANGE', 'COURSE_LICENSE_ASSIGNMENT', 'COURSE_LICENSE_GROUP_ASSIGNMENT', 'PROGRAM_LICENSE_ASSIGNMENT', 'PROGRAM_LICENSE_GROUP_ASSIGNMENT', 'USER_LICENSE_ASSIGNMENT', 'USER_LICENSE_GROUP_ASSIGNMENT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationTemplateDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "type",
            "spas_detail",
            "allowed_channels_detail",
            "is_inherited",
            "is_enabled",
            "source_platform",
            "available_context",
            "periodic_config",
            "created_at",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in spas_detail (list)
        _items = []
        if self.spas_detail:
            for _item_spas_detail in self.spas_detail:
                if _item_spas_detail:
                    _items.append(_item_spas_detail.to_dict())
            _dict['spas_detail'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in allowed_channels_detail (list)
        _items = []
        if self.allowed_channels_detail:
            for _item_allowed_channels_detail in self.allowed_channels_detail:
                if _item_allowed_channels_detail:
                    _items.append(_item_allowed_channels_detail.to_dict())
            _dict['allowed_channels_detail'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if message_title (nullable) is None
        # and model_fields_set contains the field
        if self.message_title is None and "message_title" in self.model_fields_set:
            _dict['message_title'] = None

        # set to None if email_subject (nullable) is None
        # and model_fields_set contains the field
        if self.email_subject is None and "email_subject" in self.model_fields_set:
            _dict['email_subject'] = None

        # set to None if email_from_address (nullable) is None
        # and model_fields_set contains the field
        if self.email_from_address is None and "email_from_address" in self.model_fields_set:
            _dict['email_from_address'] = None

        # set to None if email_html_template (nullable) is None
        # and model_fields_set contains the field
        if self.email_html_template is None and "email_html_template" in self.model_fields_set:
            _dict['email_html_template'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if proactive_prompt_message (nullable) is None
        # and model_fields_set contains the field
        if self.proactive_prompt_message is None and "proactive_prompt_message" in self.model_fields_set:
            _dict['proactive_prompt_message'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationTemplateDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "message_title": obj.get("message_title"),
            "message_body": obj.get("message_body"),
            "short_message_body": obj.get("short_message_body"),
            "email_subject": obj.get("email_subject"),
            "email_from_address": obj.get("email_from_address"),
            "email_html_template": obj.get("email_html_template"),
            "spas_detail": [Spa.from_dict(_item) for _item in obj["spas_detail"]] if obj.get("spas_detail") is not None else None,
            "allowed_channels_detail": [ConsumerChannel.from_dict(_item) for _item in obj["allowed_channels_detail"]] if obj.get("allowed_channels_detail") is not None else None,
            "spa_ids": obj.get("spa_ids"),
            "channel_ids": obj.get("channel_ids"),
            "is_inherited": obj.get("is_inherited"),
            "is_enabled": obj.get("is_enabled"),
            "source_platform": obj.get("source_platform"),
            "metadata": obj.get("metadata"),
            "available_context": obj.get("available_context"),
            "proactive_prompt_message": obj.get("proactive_prompt_message"),
            "periodic_config": obj.get("periodic_config"),
            "periodic_learner_scope": obj.get("periodic_learner_scope"),
            "periodic_report_period_days": obj.get("periodic_report_period_days"),
            "periodic_frequency": obj.get("periodic_frequency"),
            "periodic_custom_interval_days": obj.get("periodic_custom_interval_days"),
            "periodic_execution_time": obj.get("periodic_execution_time"),
            "periodic_timezone": obj.get("periodic_timezone"),
            "periodic_mentors": obj.get("periodic_mentors"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


