# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class NotificationTemplateList(BaseModel):
    """
    Serializer for listing notification templates with inheritance info
    """ # noqa: E501
    id: UUID = Field(description="Unique identifier for this notification template.")
    type: Optional[StrictStr] = Field(default=None, description="Select the type of notification from the available options.  * `DEFAULT_TEMPLATE` - Default Template * `APP_REGISTRATION` - App Registration * `USER_NOTIF_USER_REGISTRATION` - User Notif User Registration * `USER_NOTIF_COURSE_ENROLLMENT` - User Notif Course Enrollment * `ADMIN_NOTIF_COURSE_ENROLLMENT` - Admin Notif Course Enrollment * `USER_NOTIF_USER_INACTIVITY` - User Notif User Inactivity * `USER_NOTIF_COURSE_COMPLETION` - User Notif Course Completion * `USER_NOTIF_CREDENTIALS` - User Notif Credentials * `CUSTOM_NOTIFICATION` - Custom Notification * `PLATFORM_INVITATION` - Platform Invitation * `PROGRAM_INVITATION` - Program Invitation * `COURSE_INVITATION` - Course Invitation * `USER_NOTIF_LEARNER_PROGRESS` - User Notif Learner Progress * `PROACTIVE_LEARNER_NOTIFICATION` - Proactive Learner Notification * `ROLE_CHANGE` - Role Change * `COURSE_LICENSE_ASSIGNMENT` - Course License Assignment * `COURSE_LICENSE_GROUP_ASSIGNMENT` - Course License Group Assignment * `PROGRAM_LICENSE_ASSIGNMENT` - Program License Assignment * `PROGRAM_LICENSE_GROUP_ASSIGNMENT` - Program License Group Assignment * `USER_LICENSE_ASSIGNMENT` - User License Assignment * `USER_LICENSE_GROUP_ASSIGNMENT` - User License Group Assignment")
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="A friendly name for the notification template.")
    description: Optional[StrictStr] = Field(default=None, description="Admin-friendly description of what this notification does, when it triggers, and what data it needs")
    is_inherited: StrictBool
    source_platform: StrictStr
    is_enabled: StrictBool
    can_customize: StrictBool
    is_custom: StrictBool
    message_title: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The title for the notification message.")
    email_subject: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Email subject line (supports Django template syntax)")
    spas: StrictStr
    allowed_channels: StrictStr
    available_context: StrictStr
    __properties: ClassVar[List[str]] = ["id", "type", "name", "description", "is_inherited", "source_platform", "is_enabled", "can_customize", "is_custom", "message_title", "email_subject", "spas", "allowed_channels", "available_context"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DEFAULT_TEMPLATE', 'APP_REGISTRATION', 'USER_NOTIF_USER_REGISTRATION', 'USER_NOTIF_COURSE_ENROLLMENT', 'ADMIN_NOTIF_COURSE_ENROLLMENT', 'USER_NOTIF_USER_INACTIVITY', 'USER_NOTIF_COURSE_COMPLETION', 'USER_NOTIF_CREDENTIALS', 'CUSTOM_NOTIFICATION', 'PLATFORM_INVITATION', 'PROGRAM_INVITATION', 'COURSE_INVITATION', 'USER_NOTIF_LEARNER_PROGRESS', 'PROACTIVE_LEARNER_NOTIFICATION', 'ROLE_CHANGE', 'COURSE_LICENSE_ASSIGNMENT', 'COURSE_LICENSE_GROUP_ASSIGNMENT', 'PROGRAM_LICENSE_ASSIGNMENT', 'PROGRAM_LICENSE_GROUP_ASSIGNMENT', 'USER_LICENSE_ASSIGNMENT', 'USER_LICENSE_GROUP_ASSIGNMENT', '']):
            raise ValueError("must be one of enum values ('DEFAULT_TEMPLATE', 'APP_REGISTRATION', 'USER_NOTIF_USER_REGISTRATION', 'USER_NOTIF_COURSE_ENROLLMENT', 'ADMIN_NOTIF_COURSE_ENROLLMENT', 'USER_NOTIF_USER_INACTIVITY', 'USER_NOTIF_COURSE_COMPLETION', 'USER_NOTIF_CREDENTIALS', 'CUSTOM_NOTIFICATION', 'PLATFORM_INVITATION', 'PROGRAM_INVITATION', 'COURSE_INVITATION', 'USER_NOTIF_LEARNER_PROGRESS', 'PROACTIVE_LEARNER_NOTIFICATION', 'ROLE_CHANGE', 'COURSE_LICENSE_ASSIGNMENT', 'COURSE_LICENSE_GROUP_ASSIGNMENT', 'PROGRAM_LICENSE_ASSIGNMENT', 'PROGRAM_LICENSE_GROUP_ASSIGNMENT', 'USER_LICENSE_ASSIGNMENT', 'USER_LICENSE_GROUP_ASSIGNMENT', '')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NotificationTemplateList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "is_inherited",
            "source_platform",
            "is_enabled",
            "can_customize",
            "is_custom",
            "spas",
            "allowed_channels",
            "available_context",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if message_title (nullable) is None
        # and model_fields_set contains the field
        if self.message_title is None and "message_title" in self.model_fields_set:
            _dict['message_title'] = None

        # set to None if email_subject (nullable) is None
        # and model_fields_set contains the field
        if self.email_subject is None and "email_subject" in self.model_fields_set:
            _dict['email_subject'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NotificationTemplateList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "is_inherited": obj.get("is_inherited"),
            "source_platform": obj.get("source_platform"),
            "is_enabled": obj.get("is_enabled"),
            "can_customize": obj.get("can_customize"),
            "is_custom": obj.get("is_custom") if obj.get("is_custom") is not None else False,
            "message_title": obj.get("message_title"),
            "email_subject": obj.get("email_subject"),
            "spas": obj.get("spas"),
            "allowed_channels": obj.get("allowed_channels"),
            "available_context": obj.get("available_context")
        })
        return _obj


