# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Observation(BaseModel):
    """
    Observation
    """ # noqa: E501
    id: StrictStr
    trace_id: StrictStr
    type: StrictStr
    parent_observation_id: Optional[StrictStr] = None
    start_time: datetime
    end_time: Optional[datetime] = None
    name: StrictStr
    metadata: Optional[Any]
    level: StrictStr
    status_message: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    input: Optional[StrictStr] = None
    output: Optional[StrictStr] = None
    provided_model_name: Optional[StrictStr] = None
    internal_model_id: Optional[StrictStr] = None
    model_parameters: Optional[StrictStr] = None
    provided_usage_details: StrictStr
    usage_details: StrictStr
    provided_cost_details: StrictStr
    cost_details: StrictStr
    total_cost: Optional[Annotated[str, Field(strict=True)]] = None
    completion_start_time: Optional[datetime] = None
    prompt_id: Optional[StrictStr] = None
    prompt_name: Optional[StrictStr] = None
    prompt_version: Optional[Annotated[int, Field(le=65535, strict=True, ge=0)]] = None
    created_at: datetime
    updated_at: Optional[datetime] = None
    event_ts: datetime
    is_deleted: Annotated[int, Field(le=255, strict=True, ge=0)]
    __properties: ClassVar[List[str]] = ["id", "trace_id", "type", "parent_observation_id", "start_time", "end_time", "name", "metadata", "level", "status_message", "version", "input", "output", "provided_model_name", "internal_model_id", "model_parameters", "provided_usage_details", "usage_details", "provided_cost_details", "cost_details", "total_cost", "completion_start_time", "prompt_id", "prompt_name", "prompt_version", "created_at", "updated_at", "event_ts", "is_deleted"]

    @field_validator('total_cost')
    def total_cost_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^-?\d{0,6}(?:\.\d{0,12})?$", value):
            raise ValueError(r"must validate the regular expression /^-?\d{0,6}(?:\.\d{0,12})?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Observation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if parent_observation_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_observation_id is None and "parent_observation_id" in self.model_fields_set:
            _dict['parent_observation_id'] = None

        # set to None if end_time (nullable) is None
        # and model_fields_set contains the field
        if self.end_time is None and "end_time" in self.model_fields_set:
            _dict['end_time'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['status_message'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if input (nullable) is None
        # and model_fields_set contains the field
        if self.input is None and "input" in self.model_fields_set:
            _dict['input'] = None

        # set to None if output (nullable) is None
        # and model_fields_set contains the field
        if self.output is None and "output" in self.model_fields_set:
            _dict['output'] = None

        # set to None if provided_model_name (nullable) is None
        # and model_fields_set contains the field
        if self.provided_model_name is None and "provided_model_name" in self.model_fields_set:
            _dict['provided_model_name'] = None

        # set to None if internal_model_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_model_id is None and "internal_model_id" in self.model_fields_set:
            _dict['internal_model_id'] = None

        # set to None if model_parameters (nullable) is None
        # and model_fields_set contains the field
        if self.model_parameters is None and "model_parameters" in self.model_fields_set:
            _dict['model_parameters'] = None

        # set to None if total_cost (nullable) is None
        # and model_fields_set contains the field
        if self.total_cost is None and "total_cost" in self.model_fields_set:
            _dict['total_cost'] = None

        # set to None if completion_start_time (nullable) is None
        # and model_fields_set contains the field
        if self.completion_start_time is None and "completion_start_time" in self.model_fields_set:
            _dict['completion_start_time'] = None

        # set to None if prompt_id (nullable) is None
        # and model_fields_set contains the field
        if self.prompt_id is None and "prompt_id" in self.model_fields_set:
            _dict['prompt_id'] = None

        # set to None if prompt_name (nullable) is None
        # and model_fields_set contains the field
        if self.prompt_name is None and "prompt_name" in self.model_fields_set:
            _dict['prompt_name'] = None

        # set to None if prompt_version (nullable) is None
        # and model_fields_set contains the field
        if self.prompt_version is None and "prompt_version" in self.model_fields_set:
            _dict['prompt_version'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Observation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "trace_id": obj.get("trace_id"),
            "type": obj.get("type"),
            "parent_observation_id": obj.get("parent_observation_id"),
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time"),
            "name": obj.get("name"),
            "metadata": obj.get("metadata"),
            "level": obj.get("level"),
            "status_message": obj.get("status_message"),
            "version": obj.get("version"),
            "input": obj.get("input"),
            "output": obj.get("output"),
            "provided_model_name": obj.get("provided_model_name"),
            "internal_model_id": obj.get("internal_model_id"),
            "model_parameters": obj.get("model_parameters"),
            "provided_usage_details": obj.get("provided_usage_details"),
            "usage_details": obj.get("usage_details"),
            "provided_cost_details": obj.get("provided_cost_details"),
            "cost_details": obj.get("cost_details"),
            "total_cost": obj.get("total_cost"),
            "completion_start_time": obj.get("completion_start_time"),
            "prompt_id": obj.get("prompt_id"),
            "prompt_name": obj.get("prompt_name"),
            "prompt_version": obj.get("prompt_version"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "event_ts": obj.get("event_ts"),
            "is_deleted": obj.get("is_deleted")
        })
        return _obj


