# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class OvertimeMeta(BaseModel):
    """
    OvertimeMeta
    """ # noqa: E501
    total: StrictInt = Field(description="Total records")
    change_range: Optional[StrictInt] = Field(default=0, description="Change in range")
    change_last_seven_days: Optional[StrictInt] = Field(default=0, description="Change in last 7 days")
    change_last_thirty_days: Optional[StrictInt] = Field(default=0, description="Change in last 30 days")
    change_last_seven_days_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Change in last 7 days in percentage")
    change_last_thirty_days_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.0, description="Change in last 30 days in percentage")
    change_range_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Change in range in percentage")
    __properties: ClassVar[List[str]] = ["total", "change_range", "change_last_seven_days", "change_last_thirty_days", "change_last_seven_days_percent", "change_last_thirty_days_percent", "change_range_percent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OvertimeMeta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OvertimeMeta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total": obj.get("total"),
            "change_range": obj.get("change_range") if obj.get("change_range") is not None else 0,
            "change_last_seven_days": obj.get("change_last_seven_days") if obj.get("change_last_seven_days") is not None else 0,
            "change_last_thirty_days": obj.get("change_last_thirty_days") if obj.get("change_last_thirty_days") is not None else 0,
            "change_last_seven_days_percent": obj.get("change_last_seven_days_percent") if obj.get("change_last_seven_days_percent") is not None else 0.0,
            "change_last_thirty_days_percent": obj.get("change_last_thirty_days_percent") if obj.get("change_last_thirty_days_percent") is not None else 0.0,
            "change_range_percent": obj.get("change_range_percent")
        })
        return _obj


