# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.program_license_detail import ProgramLicenseDetail
from typing import Optional, Set
from typing_extensions import Self

class PaginatedProgramLicense(BaseModel):
    """
    Response serializer for paginated program license list.  This serializer represents a paginated list of program licenses, with navigation links and metadata.  Fields:     count: Total number of results matching the query     next: URL for the next page of results (null if no next page)     previous: URL for the previous page of results (null if no previous page)     results: List of program licenses
    """ # noqa: E501
    count: StrictInt = Field(description="Total number of results")
    next_page: Optional[StrictStr] = Field(description="URL for next page of results")
    previous_page: Optional[StrictStr] = Field(description="URL for previous page of results")
    results: List[ProgramLicenseDetail] = Field(description="List of program licenses")
    __properties: ClassVar[List[str]] = ["count", "next_page", "previous_page", "results"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaginatedProgramLicense from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item_results in self.results:
                if _item_results:
                    _items.append(_item_results.to_dict())
            _dict['results'] = _items
        # set to None if next_page (nullable) is None
        # and model_fields_set contains the field
        if self.next_page is None and "next_page" in self.model_fields_set:
            _dict['next_page'] = None

        # set to None if previous_page (nullable) is None
        # and model_fields_set contains the field
        if self.previous_page is None and "previous_page" in self.model_fields_set:
            _dict['previous_page'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaginatedProgramLicense from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "count": obj.get("count"),
            "next_page": obj.get("next_page"),
            "previous_page": obj.get("previous_page"),
            "results": [ProgramLicenseDetail.from_dict(_item) for _item in obj["results"]] if obj.get("results") is not None else None
        })
        return _obj


