# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class PatchedArtifact(BaseModel):
    """
    Serializer for Artifact model.  Artifacts are structured content like essays, documents, code files, etc. that are generated by AI agents during a chat session and are best displayed separately from the normal chat flow.  Fields:     - id: Unique identifier for the artifact     - title: Title or identifier for the artifact     - content: The markdown-styled content of the artifact     - file_extension: The extension of the file (e.g., 'py', 'md', 'html', 'json', 'csv')     - chat_message: Reference to the chat message that contains this artifact     - llm_name: Name of the LLM that generated the artifact     - llm_provider: Provider of the LLM (e.g., 'openai', 'google', 'anthropic')     - date_created: Timestamp when the artifact was created     - date_updated: Timestamp when the artifact was last updated     - metadata: Additional metadata for the artifact     - username: Username of the student who owns the artifact (read-only)     - session_id: UUID of the session that generated the artifact (read-only)  Read-only fields:     - id, date_created, date_updated, username, session_id
    """ # noqa: E501
    id: Optional[StrictInt] = None
    title: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Title or identifier for the artifact")
    content: Optional[StrictStr] = Field(default=None, description="The markdown-styled content of the artifact")
    file_extension: Optional[StrictStr] = Field(default=None, description="The extension of the file for the artifact. eg. `py`, `md`, `html`, `json`, `csv`, etc")
    chat_message: Optional[StrictInt] = None
    llm_name: Optional[StrictStr] = None
    llm_provider: Optional[StrictStr] = None
    date_created: Optional[datetime] = None
    date_updated: Optional[datetime] = None
    metadata: Optional[Any] = Field(default=None, description="Additional metadata for the artifact")
    username: Optional[StrictStr] = Field(default=None, description="Username of the student who owns this artifact")
    session_id: Optional[UUID] = Field(default=None, description="UUID of the session that generated this artifact")
    __properties: ClassVar[List[str]] = ["id", "title", "content", "file_extension", "chat_message", "llm_name", "llm_provider", "date_created", "date_updated", "metadata", "username", "session_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedArtifact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "file_extension",
            "chat_message",
            "llm_name",
            "llm_provider",
            "date_created",
            "date_updated",
            "username",
            "session_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedArtifact from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "content": obj.get("content"),
            "file_extension": obj.get("file_extension"),
            "chat_message": obj.get("chat_message"),
            "llm_name": obj.get("llm_name"),
            "llm_provider": obj.get("llm_provider"),
            "date_created": obj.get("date_created"),
            "date_updated": obj.get("date_updated"),
            "metadata": obj.get("metadata"),
            "username": obj.get("username"),
            "session_id": obj.get("session_id")
        })
        return _obj


