# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from iblai.models.call_configuration_mode_enum import CallConfigurationModeEnum
from iblai.models.llm_provider_enum import LlmProviderEnum
from iblai.models.stt_provider_enum import SttProviderEnum
from iblai.models.tts_provider_enum import TtsProviderEnum
from iblai.models.voice import Voice
from typing import Optional, Set
from typing_extensions import Self

class PatchedCallConfiguration(BaseModel):
    """
    PatchedCallConfiguration
    """ # noqa: E501
    id: Optional[StrictInt] = None
    mentor: Optional[UUID] = None
    mode: Optional[CallConfigurationModeEnum] = None
    tts_provider: Optional[TtsProviderEnum] = None
    stt_provider: Optional[SttProviderEnum] = None
    llm_provider: Optional[LlmProviderEnum] = None
    use_function_calling_for_rag: Optional[StrictBool] = Field(default=None, description="Whether to use function calls in the agent or force RAG calls before LLM generation")
    google_voice: Optional[Voice] = None
    openai_voice: Optional[Voice] = None
    openai_voice_id: Optional[StrictInt] = None
    google_voice_id: Optional[StrictInt] = None
    enable_video: Optional[StrictBool] = Field(default=None, description="Whether to enable video for the call. (applicable only for realtime mode)")
    platform_key: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "mentor", "mode", "tts_provider", "stt_provider", "llm_provider", "use_function_calling_for_rag", "google_voice", "openai_voice", "openai_voice_id", "google_voice_id", "enable_video", "platform_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedCallConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform_key",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of google_voice
        if self.google_voice:
            _dict['google_voice'] = self.google_voice.to_dict()
        # override the default output from pydantic by calling `to_dict()` of openai_voice
        if self.openai_voice:
            _dict['openai_voice'] = self.openai_voice.to_dict()
        # set to None if openai_voice_id (nullable) is None
        # and model_fields_set contains the field
        if self.openai_voice_id is None and "openai_voice_id" in self.model_fields_set:
            _dict['openai_voice_id'] = None

        # set to None if google_voice_id (nullable) is None
        # and model_fields_set contains the field
        if self.google_voice_id is None and "google_voice_id" in self.model_fields_set:
            _dict['google_voice_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedCallConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "mentor": obj.get("mentor"),
            "mode": obj.get("mode"),
            "tts_provider": obj.get("tts_provider"),
            "stt_provider": obj.get("stt_provider"),
            "llm_provider": obj.get("llm_provider"),
            "use_function_calling_for_rag": obj.get("use_function_calling_for_rag"),
            "google_voice": Voice.from_dict(obj["google_voice"]) if obj.get("google_voice") is not None else None,
            "openai_voice": Voice.from_dict(obj["openai_voice"]) if obj.get("openai_voice") is not None else None,
            "openai_voice_id": obj.get("openai_voice_id"),
            "google_voice_id": obj.get("google_voice_id"),
            "enable_video": obj.get("enable_video"),
            "platform_key": obj.get("platform_key")
        })
        return _obj


