# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.scope_enum import ScopeEnum
from typing import Optional, Set
from typing_extensions import Self

class PatchedDisclaimer(BaseModel):
    """
    PatchedDisclaimer
    """ # noqa: E501
    id: Optional[StrictInt] = None
    scope: Optional[ScopeEnum] = None
    platform: Optional[StrictInt] = Field(default=None, description="Platform to which the disclaimer applies. ")
    content: Optional[StrictStr] = None
    title: Optional[Annotated[str, Field(strict=True, max_length=120)]] = None
    active: Optional[StrictBool] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    has_agreed: Optional[StrictBool] = None
    platform_key: Optional[StrictStr] = None
    mentors: Optional[List[UUID]] = None
    __properties: ClassVar[List[str]] = ["id", "scope", "platform", "content", "title", "active", "created_at", "updated_at", "has_agreed", "platform_key", "mentors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedDisclaimer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform",
            "created_at",
            "updated_at",
            "has_agreed",
            "platform_key",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedDisclaimer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "scope": obj.get("scope"),
            "platform": obj.get("platform"),
            "content": obj.get("content"),
            "title": obj.get("title"),
            "active": obj.get("active"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "has_agreed": obj.get("has_agreed"),
            "platform_key": obj.get("platform_key"),
            "mentors": obj.get("mentors")
        })
        return _obj


