# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.auth_type_enum import AuthTypeEnum
from iblai.models.transport_enum import TransportEnum
from typing import Optional, Set
from typing_extensions import Self

class PatchedMCPServer(BaseModel):
    """
    Serializer for the MCPServer model.
    """ # noqa: E501
    id: Optional[StrictInt] = None
    platform: Optional[StrictInt] = None
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    description: Optional[StrictStr] = Field(default=None, description="A description of the MCP server.")
    url: Optional[Annotated[str, Field(strict=True, max_length=200)]] = Field(default=None, description="The url of the MCP server.")
    image: Optional[StrictStr] = None
    transport: Optional[TransportEnum] = None
    credentials: Optional[StrictStr] = Field(default=None, description="Authorization credentials to uauthenticate to the mcp server. if provided takes priority over connected service and headers. Token here must be the full authorization value. For example: `<scheme> <credentials>`")
    extra_headers: Optional[Any] = Field(default=None, description="Headers to send to the MCP server. Useful for authentication,")
    platform_key: Optional[StrictStr] = None
    is_featured: Optional[StrictBool] = Field(default=None, description="Featured mcp servers will be accessible to all other tenants.")
    auth_type: Optional[AuthTypeEnum] = Field(default=None, description="The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2")
    is_enabled: Optional[StrictBool] = Field(default=None, description="Whether the MCP server is enabled or not.")
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "platform", "name", "description", "url", "image", "transport", "credentials", "extra_headers", "platform_key", "is_featured", "auth_type", "is_enabled", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedMCPServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform",
            "platform_key",
            "created_at",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if image (nullable) is None
        # and model_fields_set contains the field
        if self.image is None and "image" in self.model_fields_set:
            _dict['image'] = None

        # set to None if extra_headers (nullable) is None
        # and model_fields_set contains the field
        if self.extra_headers is None and "extra_headers" in self.model_fields_set:
            _dict['extra_headers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedMCPServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "platform": obj.get("platform"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "image": obj.get("image"),
            "transport": obj.get("transport"),
            "credentials": obj.get("credentials"),
            "extra_headers": obj.get("extra_headers"),
            "platform_key": obj.get("platform_key"),
            "is_featured": obj.get("is_featured"),
            "auth_type": obj.get("auth_type"),
            "is_enabled": obj.get("is_enabled"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


