# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.item_type_enum import ItemTypeEnum
from iblai.models.media_type_enum import MediaTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class PatchedMediaResource(BaseModel):
    """
    PatchedMediaResource
    """ # noqa: E501
    id: Optional[StrictInt] = None
    title: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Title of the media resource")
    description: Optional[StrictStr] = Field(default=None, description="Description of the media resource")
    media_type: Optional[MediaTypeEnum] = Field(default=None, description="Type of media  * `video` - Video * `image` - Image * `document` - Document * `audio` - Audio * `other` - Other")
    item_type: Optional[ItemTypeEnum] = Field(default=None, description="Type of item this media is associated with  * `course` - Course * `unit` - Unit * `resource` - Resource * `course_unit` - Course and Unit * `course_resource` - Course and Resource * `unit_resource` - Unit and Resource * `all` - Course, Unit, and Resource")
    course_id: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="ID of the associated course")
    unit_id: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="ID of the associated unit")
    item_id: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="ID of the associated item (resource)")
    platform: Optional[StrictInt] = Field(default=None, description="The platform this media resource belongs to")
    file_url: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = Field(default=None, description="External URL for the media resource")
    file: Optional[StrictStr] = Field(default=None, description="Uploaded media file")
    created_by: Optional[StrictInt] = Field(default=None, description="User who created this media resource")
    created_at: Optional[datetime] = Field(default=None, description="When this record was created")
    updated_at: Optional[datetime] = Field(default=None, description="When this record was last updated")
    __properties: ClassVar[List[str]] = ["id", "title", "description", "media_type", "item_type", "course_id", "unit_id", "item_id", "platform", "file_url", "file", "created_by", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedMediaResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "item_type",
            "platform",
            "created_by",
            "created_at",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if course_id (nullable) is None
        # and model_fields_set contains the field
        if self.course_id is None and "course_id" in self.model_fields_set:
            _dict['course_id'] = None

        # set to None if unit_id (nullable) is None
        # and model_fields_set contains the field
        if self.unit_id is None and "unit_id" in self.model_fields_set:
            _dict['unit_id'] = None

        # set to None if item_id (nullable) is None
        # and model_fields_set contains the field
        if self.item_id is None and "item_id" in self.model_fields_set:
            _dict['item_id'] = None

        # set to None if file_url (nullable) is None
        # and model_fields_set contains the field
        if self.file_url is None and "file_url" in self.model_fields_set:
            _dict['file_url'] = None

        # set to None if file (nullable) is None
        # and model_fields_set contains the field
        if self.file is None and "file" in self.model_fields_set:
            _dict['file'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['created_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedMediaResource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "media_type": obj.get("media_type"),
            "item_type": obj.get("item_type"),
            "course_id": obj.get("course_id"),
            "unit_id": obj.get("unit_id"),
            "item_id": obj.get("item_id"),
            "platform": obj.get("platform"),
            "file_url": obj.get("file_url"),
            "file": obj.get("file"),
            "created_by": obj.get("created_by"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


