# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.project_mentor import ProjectMentor
from typing import Optional, Set
from typing_extensions import Self

class PatchedProject(BaseModel):
    """
    Unified serializer for Project model.  Write-only fields: - mentors_to_add: List of mentor unique IDs to add to the project - mentors_to_remove: List of mentor unique IDs to remove from the project  These fields are mutually exclusive and only used during create/update operations. For create: only mentors_to_add is used For update: either can be used, but not both at once
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Name of the project")
    description: Optional[StrictStr] = Field(default=None, description="Description of the project")
    shared: Optional[StrictBool] = Field(default=None, description="Whether this project is shared with others or personal")
    owner: Optional[StrictInt] = Field(default=None, description="User who created this project")
    owner_username: Optional[StrictStr] = None
    platform: Optional[StrictInt] = Field(default=None, description="Platform this project belongs to")
    platform_key: Optional[StrictStr] = None
    platform_name: Optional[StrictStr] = None
    mentor_count: Optional[StrictInt] = None
    is_personal: Optional[StrictBool] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    mentors: Optional[List[ProjectMentor]] = None
    mentors_to_add: Optional[List[UUID]] = Field(default=None, description="List of mentor unique IDs to add to the project")
    mentors_to_remove: Optional[List[UUID]] = Field(default=None, description="List of mentor unique IDs to remove from the project")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "shared", "owner", "owner_username", "platform", "platform_key", "platform_name", "mentor_count", "is_personal", "created_at", "updated_at", "mentors", "mentors_to_add", "mentors_to_remove"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedProject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "owner",
            "owner_username",
            "platform",
            "platform_key",
            "platform_name",
            "mentor_count",
            "is_personal",
            "created_at",
            "updated_at",
            "mentors",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in mentors (list)
        _items = []
        if self.mentors:
            for _item_mentors in self.mentors:
                if _item_mentors:
                    _items.append(_item_mentors.to_dict())
            _dict['mentors'] = _items
        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedProject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "shared": obj.get("shared"),
            "owner": obj.get("owner"),
            "owner_username": obj.get("owner_username"),
            "platform": obj.get("platform"),
            "platform_key": obj.get("platform_key"),
            "platform_name": obj.get("platform_name"),
            "mentor_count": obj.get("mentor_count"),
            "is_personal": obj.get("is_personal"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "mentors": [ProjectMentor.from_dict(_item) for _item in obj["mentors"]] if obj.get("mentors") is not None else None,
            "mentors_to_add": obj.get("mentors_to_add"),
            "mentors_to_remove": obj.get("mentors_to_remove")
        })
        return _obj


