# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.rbac_platform import RbacPlatform
from iblai.models.rbac_user import RbacUser
from typing import Optional, Set
from typing_extensions import Self

class PatchedRbacGroup(BaseModel):
    """
    Serializer for RBAC groups.
    """ # noqa: E501
    id: Optional[StrictInt] = None
    unique_id: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The unique identifier for the group")
    platform: Optional[RbacPlatform] = None
    platform_key: Optional[StrictStr] = Field(default=None, description="The platform key")
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Optional name of the group")
    description: Optional[StrictStr] = Field(default=None, description="Optional group description")
    owner: Optional[RbacUser] = None
    users: Optional[List[RbacUser]] = None
    users_to_add: Optional[List[StrictInt]] = Field(default=None, description="List of user IDs to add to this group")
    users_to_remove: Optional[List[StrictInt]] = Field(default=None, description="List of user IDs to remove from this group")
    is_internal: Optional[StrictBool] = Field(default=None, description="When True, this group is internal to the system and cannot be viewed or modified by tenants via API endpoints.")
    __properties: ClassVar[List[str]] = ["id", "unique_id", "platform", "platform_key", "name", "description", "owner", "users", "users_to_add", "users_to_remove", "is_internal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatchedRbacGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform",
            "owner",
            "users",
            "is_internal",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatchedRbacGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "unique_id": obj.get("unique_id"),
            "platform": RbacPlatform.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "platform_key": obj.get("platform_key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "owner": RbacUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "users": [RbacUser.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "users_to_add": obj.get("users_to_add"),
            "users_to_remove": obj.get("users_to_remove"),
            "is_internal": obj.get("is_internal")
        })
        return _obj


