# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class Pathway(BaseModel):
    """
    Pathway
    """ # noqa: E501
    id: StrictInt
    pathway_id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="A unique pathway ID.")
    pathway_uuid: Optional[UUID] = None
    path: StrictStr
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The verbose name of the pathway.")
    visible: Optional[StrictBool] = Field(default=None, description="Pathway visibility")
    slug: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="An additional unique slug field. (Optional)")
    user_id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    platform_key: Optional[StrictStr] = None
    data: Optional[Any] = Field(default=None, description="Metadata")
    __properties: ClassVar[List[str]] = ["id", "pathway_id", "pathway_uuid", "path", "name", "visible", "slug", "user_id", "username", "platform_key", "data"]

    @field_validator('slug')
    def slug_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[-a-zA-Z0-9_]+$", value):
            raise ValueError(r"must validate the regular expression /^[-a-zA-Z0-9_]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Pathway from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "path",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Pathway from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "pathway_id": obj.get("pathway_id"),
            "pathway_uuid": obj.get("pathway_uuid"),
            "path": obj.get("path"),
            "name": obj.get("name"),
            "visible": obj.get("visible"),
            "slug": obj.get("slug"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "platform_key": obj.get("platform_key"),
            "data": obj.get("data")
        })
        return _obj


