# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PathwaySelfEnrollmentRequest(BaseModel):
    """
    Serializer for pathway self-enrollment request parameters.
    """ # noqa: E501
    user_id: Optional[StrictStr] = Field(default=None, description="User ID for self-enrollment")
    username: Optional[StrictStr] = Field(default=None, description="Username for self-enrollment")
    pathway_id: Optional[StrictStr] = Field(default=None, description="Pathway ID for self-enrollment")
    pathway_key: Optional[StrictStr] = Field(default=None, description="Pathway key for self-enrollment")
    slug: Optional[StrictStr] = Field(default=None, description="Pathway slug for self-enrollment")
    org: Optional[StrictStr] = Field(default=None, description="Organization for the pathway")
    platform_key: Optional[StrictStr] = Field(default=None, description="Platform key for the pathway")
    active: Optional[StrictBool] = Field(default=True, description="Whether the enrollment should be active")
    __properties: ClassVar[List[str]] = ["user_id", "username", "pathway_id", "pathway_key", "slug", "org", "platform_key", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PathwaySelfEnrollmentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PathwaySelfEnrollmentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "pathway_id": obj.get("pathway_id"),
            "pathway_key": obj.get("pathway_key"),
            "slug": obj.get("slug"),
            "org": obj.get("org"),
            "platform_key": obj.get("platform_key"),
            "active": obj.get("active") if obj.get("active") is not None else True
        })
        return _obj


