# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PathwaySuggestionCreate(BaseModel):
    """
    Request serializer for PathwaySuggestionManagementView POST endpoint
    """ # noqa: E501
    platform_key: StrictStr = Field(description="The platform for the suggestion")
    pathway_id: StrictStr = Field(description="The pathway ID to suggest")
    pathway_uuid: StrictStr = Field(description="The pathway UUID to suggest")
    user_id: StrictStr = Field(description="The user to suggest the pathway to")
    username: Optional[StrictStr] = Field(default=None, description="The username of the user to suggest the pathway to")
    email: Optional[StrictStr] = Field(default=None, description="The email of the user to suggest the pathway to")
    accepted: Optional[StrictBool] = Field(default=False, description="Whether the suggestion is accepted")
    visible: Optional[StrictBool] = Field(default=True, description="Whether the suggestion is visible")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional suggestion metadata")
    suggested_by: Optional[StrictStr] = Field(default=None, description="The user who suggested the pathway")
    direct: Optional[StrictBool] = Field(default=True, description="Whether the suggestion is direct")
    department_mode: Optional[StrictBool] = Field(default=False, description="Flag to ensure department admins can call the API")
    __properties: ClassVar[List[str]] = ["platform_key", "pathway_id", "pathway_uuid", "user_id", "username", "email", "accepted", "visible", "metadata", "suggested_by", "direct", "department_mode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PathwaySuggestionCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PathwaySuggestionCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "platform_key": obj.get("platform_key"),
            "pathway_id": obj.get("pathway_id"),
            "pathway_uuid": obj.get("pathway_uuid"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "accepted": obj.get("accepted") if obj.get("accepted") is not None else False,
            "visible": obj.get("visible") if obj.get("visible") is not None else True,
            "metadata": obj.get("metadata"),
            "suggested_by": obj.get("suggested_by"),
            "direct": obj.get("direct") if obj.get("direct") is not None else True,
            "department_mode": obj.get("department_mode") if obj.get("department_mode") is not None else False
        })
        return _obj


