# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class PathwaySuggestionDetail(BaseModel):
    """
    Response serializer for pathway suggestion details
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the suggestion")
    user_id: StrictInt = Field(description="The ID of the user receiving the suggestion")
    username: StrictStr = Field(description="The username of the user receiving the suggestion")
    name: StrictStr = Field(description="The full name of the user receiving the suggestion")
    platform_key: StrictStr = Field(description="The platform key associated with the suggestion")
    accepted: StrictBool = Field(description="Whether the suggestion has been accepted by the user")
    visible: StrictBool = Field(description="Whether the suggestion is visible to the user")
    created: datetime = Field(description="When the suggestion was created")
    modified: datetime = Field(description="When the suggestion was last modified")
    metadata: Dict[str, Any] = Field(description="Additional metadata for the suggestion")
    pathway_id: StrictStr = Field(description="The pathway ID being suggested")
    pathway_uuid: StrictStr = Field(description="The UUID of the pathway being suggested")
    pathway_name: StrictStr = Field(description="The name of the pathway being suggested")
    pathway_platform_key: StrictStr = Field(description="The platform key associated with the pathway")
    __properties: ClassVar[List[str]] = ["id", "user_id", "username", "name", "platform_key", "accepted", "visible", "created", "modified", "metadata", "pathway_id", "pathway_uuid", "pathway_name", "pathway_platform_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PathwaySuggestionDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PathwaySuggestionDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "platform_key": obj.get("platform_key"),
            "accepted": obj.get("accepted"),
            "visible": obj.get("visible"),
            "created": obj.get("created"),
            "modified": obj.get("modified"),
            "metadata": obj.get("metadata"),
            "pathway_id": obj.get("pathway_id"),
            "pathway_uuid": obj.get("pathway_uuid"),
            "pathway_name": obj.get("pathway_name"),
            "pathway_platform_key": obj.get("pathway_platform_key")
        })
        return _obj


