# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.mentor import Mentor
from iblai.models.periodic_task import PeriodicTask
from iblai.models.previous_agent_status_enum import PreviousAgentStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class PeriodicAgent(BaseModel):
    """
    PeriodicAgent
    """ # noqa: E501
    id: StrictInt
    mentor: Mentor
    title: Annotated[str, Field(strict=True, max_length=255)]
    username: StrictStr
    description: Optional[StrictStr] = None
    prompt: Optional[StrictStr] = Field(default=None, description="Prompt for the periodic agent if any.")
    task: PeriodicTask
    created_at: datetime
    modified_at: datetime
    enabled: StrictBool
    one_off: StrictBool
    platform_key: StrictStr
    pathway: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    callback_url: Optional[Annotated[str, Field(strict=True, max_length=200)]] = None
    callback_secret: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    parent_session_id: Optional[Annotated[str, Field(strict=True, max_length=200)]] = None
    parent_mentor_id: Optional[StrictInt] = None
    previous_agent: Optional[StrictInt] = Field(default=None, description="Agent that needs to run before the current agent runs.")
    previous_agent_status: Optional[PreviousAgentStatusEnum] = Field(default=None, description="The status that the previous agent must be in before this agent gets scheduled.  * `success` - Success * `error` - Error * `running` - Running * `pending` - Pending")
    previous_agent_output: StrictStr = Field(description="This will be fed into the run of this agent as part of its input prompt.")
    __properties: ClassVar[List[str]] = ["id", "mentor", "title", "username", "description", "prompt", "task", "created_at", "modified_at", "enabled", "one_off", "platform_key", "pathway", "callback_url", "callback_secret", "parent_session_id", "parent_mentor_id", "previous_agent", "previous_agent_status", "previous_agent_output"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PeriodicAgent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "username",
            "created_at",
            "modified_at",
            "enabled",
            "one_off",
            "platform_key",
            "previous_agent_output",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mentor
        if self.mentor:
            _dict['mentor'] = self.mentor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task
        if self.task:
            _dict['task'] = self.task.to_dict()
        # set to None if parent_mentor_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_mentor_id is None and "parent_mentor_id" in self.model_fields_set:
            _dict['parent_mentor_id'] = None

        # set to None if previous_agent (nullable) is None
        # and model_fields_set contains the field
        if self.previous_agent is None and "previous_agent" in self.model_fields_set:
            _dict['previous_agent'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PeriodicAgent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "mentor": Mentor.from_dict(obj["mentor"]) if obj.get("mentor") is not None else None,
            "title": obj.get("title"),
            "username": obj.get("username"),
            "description": obj.get("description"),
            "prompt": obj.get("prompt"),
            "task": PeriodicTask.from_dict(obj["task"]) if obj.get("task") is not None else None,
            "created_at": obj.get("created_at"),
            "modified_at": obj.get("modified_at"),
            "enabled": obj.get("enabled"),
            "one_off": obj.get("one_off"),
            "platform_key": obj.get("platform_key"),
            "pathway": obj.get("pathway"),
            "callback_url": obj.get("callback_url"),
            "callback_secret": obj.get("callback_secret"),
            "parent_session_id": obj.get("parent_session_id"),
            "parent_mentor_id": obj.get("parent_mentor_id"),
            "previous_agent": obj.get("previous_agent"),
            "previous_agent_status": obj.get("previous_agent_status"),
            "previous_agent_output": obj.get("previous_agent_output")
        })
        return _obj


