# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class PerlearnerGradingPerCourseAPIData(BaseModel):
    """
    PerlearnerGradingPerCourseAPIData
    """ # noqa: E501
    course_id: StrictStr = Field(description="Edx Course ID")
    name: StrictStr = Field(description="Course Name")
    graded_activities: StrictStr = Field(description="Total problems in course")
    submissions: StrictInt = Field(description="Cumulative problem submissions")
    problems_attempted: StrictInt = Field(description="Number of problems from total problems attempted")
    assignments_correct: StrictInt = Field(description="Number of problems answered correctly")
    class_average: Union[StrictFloat, StrictInt] = Field(description="Average grade obtained by all learner in the course")
    grade: Union[StrictFloat, StrictInt] = Field(description="Learner course grade")
    __properties: ClassVar[List[str]] = ["course_id", "name", "graded_activities", "submissions", "problems_attempted", "assignments_correct", "class_average", "grade"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PerlearnerGradingPerCourseAPIData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PerlearnerGradingPerCourseAPIData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "course_id": obj.get("course_id"),
            "name": obj.get("name"),
            "graded_activities": obj.get("graded_activities"),
            "submissions": obj.get("submissions"),
            "problems_attempted": obj.get("problems_attempted"),
            "assignments_correct": obj.get("assignments_correct"),
            "class_average": obj.get("class_average"),
            "grade": obj.get("grade")
        })
        return _obj


