# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class PerlearnerUserListData(BaseModel):
    """
    PerlearnerUserListData
    """ # noqa: E501
    username: StrictStr = Field(description="learner username")
    full_name: StrictStr = Field(description="learner Name")
    enrollments: StrictInt = Field(description="Total enrollments")
    completions: StrictInt = Field(description="Total completions")
    last_active: StrictStr = Field(description="Last active time")
    time_spent: StrictStr = Field(description="Time spent formatted in seconds")
    engagement_index: Union[StrictFloat, StrictInt] = Field(description="Engagement index")
    performance_index: Union[StrictFloat, StrictInt] = Field(description="Performance index")
    __properties: ClassVar[List[str]] = ["username", "full_name", "enrollments", "completions", "last_active", "time_spent", "engagement_index", "performance_index"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PerlearnerUserListData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PerlearnerUserListData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "full_name": obj.get("full_name"),
            "enrollments": obj.get("enrollments"),
            "completions": obj.get("completions"),
            "last_active": obj.get("last_active"),
            "time_spent": obj.get("time_spent"),
            "engagement_index": obj.get("engagement_index"),
            "performance_index": obj.get("performance_index")
        })
        return _obj


