# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class PlatformApiKey(BaseModel):
    """
    Serializer for PlatformApiKey's
    """ # noqa: E501
    username: StrictStr = Field(description="Username that created token")
    name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="Name of the token. Used by the user to identify the token.")
    key: StrictStr
    platform_key: StrictStr = Field(description="The platform key")
    expires: datetime = Field(description="When token expires")
    expires_in: Optional[StrictStr] = Field(default=None, description="Optional duration until key expires. Format: [DD] [HH:[MM:]]ss[.uuuuuu]")
    created: datetime = Field(description="When token was created")
    __properties: ClassVar[List[str]] = ["username", "name", "key", "platform_key", "expires", "expires_in", "created"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[-a-zA-Z0-9_]+$", value):
            raise ValueError(r"must validate the regular expression /^[-a-zA-Z0-9_]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlatformApiKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "username",
            "key",
            "expires",
            "created",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if expires_in (nullable) is None
        # and model_fields_set contains the field
        if self.expires_in is None and "expires_in" in self.model_fields_set:
            _dict['expires_in'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlatformApiKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "name": obj.get("name"),
            "key": obj.get("key"),
            "platform_key": obj.get("platform_key"),
            "expires": obj.get("expires"),
            "expires_in": obj.get("expires_in"),
            "created": obj.get("created")
        })
        return _obj


