# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.platform_list_status_enum import PlatformListStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class PlatformList(BaseModel):
    """
    PlatformList
    """ # noqa: E501
    key: Annotated[str, Field(strict=True, max_length=200)] = Field(description="The platform key")
    name: Optional[Annotated[str, Field(strict=True, max_length=200)]] = Field(default=None, description="The name of the platform")
    org: Optional[Annotated[str, Field(strict=True, max_length=200)]] = Field(default=None, description="The associated edX org code")
    lms_url: Optional[Annotated[str, Field(strict=True, max_length=300)]] = Field(default=None, description="The LMS URL for the platform")
    cms_url: Optional[Annotated[str, Field(strict=True, max_length=300)]] = Field(default=None, description="The CMS URL for the platform")
    portal_url: Optional[Annotated[str, Field(strict=True, max_length=300)]] = Field(default=None, description="The portal URL for the platform")
    status: Optional[PlatformListStatusEnum] = None
    active: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["key", "name", "org", "lms_url", "cms_url", "portal_url", "status", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlatformList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if org (nullable) is None
        # and model_fields_set contains the field
        if self.org is None and "org" in self.model_fields_set:
            _dict['org'] = None

        # set to None if lms_url (nullable) is None
        # and model_fields_set contains the field
        if self.lms_url is None and "lms_url" in self.model_fields_set:
            _dict['lms_url'] = None

        # set to None if cms_url (nullable) is None
        # and model_fields_set contains the field
        if self.cms_url is None and "cms_url" in self.model_fields_set:
            _dict['cms_url'] = None

        # set to None if portal_url (nullable) is None
        # and model_fields_set contains the field
        if self.portal_url is None and "portal_url" in self.model_fields_set:
            _dict['portal_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlatformList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "name": obj.get("name"),
            "org": obj.get("org"),
            "lms_url": obj.get("lms_url"),
            "cms_url": obj.get("cms_url"),
            "portal_url": obj.get("portal_url"),
            "status": obj.get("status"),
            "active": obj.get("active")
        })
        return _obj


