# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from iblai.models.metric_detail import MetricDetail
from iblai.models.points_metric import PointsMetric
from iblai.models.skills_metric import SkillsMetric
from typing import Optional, Set
from typing_extensions import Self

class PlatformMetrics(BaseModel):
    """
    Serializer for detailed platform metrics (platform-specific view).
    """ # noqa: E501
    enrollments: MetricDetail
    programs: MetricDetail
    pathways: MetricDetail
    resources: MetricDetail
    skills: SkillsMetric
    credentials: MetricDetail
    points: PointsMetric
    __properties: ClassVar[List[str]] = ["enrollments", "programs", "pathways", "resources", "skills", "credentials", "points"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlatformMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of enrollments
        if self.enrollments:
            _dict['enrollments'] = self.enrollments.to_dict()
        # override the default output from pydantic by calling `to_dict()` of programs
        if self.programs:
            _dict['programs'] = self.programs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pathways
        if self.pathways:
            _dict['pathways'] = self.pathways.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resources
        if self.resources:
            _dict['resources'] = self.resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of skills
        if self.skills:
            _dict['skills'] = self.skills.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credentials
        if self.credentials:
            _dict['credentials'] = self.credentials.to_dict()
        # override the default output from pydantic by calling `to_dict()` of points
        if self.points:
            _dict['points'] = self.points.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlatformMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enrollments": MetricDetail.from_dict(obj["enrollments"]) if obj.get("enrollments") is not None else None,
            "programs": MetricDetail.from_dict(obj["programs"]) if obj.get("programs") is not None else None,
            "pathways": MetricDetail.from_dict(obj["pathways"]) if obj.get("pathways") is not None else None,
            "resources": MetricDetail.from_dict(obj["resources"]) if obj.get("resources") is not None else None,
            "skills": SkillsMetric.from_dict(obj["skills"]) if obj.get("skills") is not None else None,
            "credentials": MetricDetail.from_dict(obj["credentials"]) if obj.get("credentials") is not None else None,
            "points": PointsMetric.from_dict(obj["points"]) if obj.get("points") is not None else None
        })
        return _obj


