# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.recommendation_type_enum import RecommendationTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class PlatformPrompt(BaseModel):
    """
    Serializer for platform recommendation prompt management.  Used by instructors/admins to configure tenant-specific prompts for different SPAs. A platform can have multiple prompts (one per SPA/frontend).  Note: spa_url will be automatically normalized (protocol stripped, lowercase) during validation.
    """ # noqa: E501
    platform_key: Optional[StrictStr] = Field(default=None, description="Platform key this prompt belongs to")
    prompt_text: Optional[StrictStr] = Field(default=None, description="The custom recommendation strategy prompt")
    recommendation_type: Optional[RecommendationTypeEnum] = Field(default=None, description="Prompt category. Use 'catalog' for courses/programs/resources/pathways; use 'mentors' for mentor prompts.  * `mentors` - Mentor Recommendations * `catalog` - Catalog Recommendations")
    spa_url: Optional[StrictStr] = Field(default=None, description="Frontend/SPA identifier (e.g., 'catalog.example.com', 'mentor-ai.ibl.com', 'https://mentor-ai.ibl.com'). Protocol and case will be normalized automatically. Leave blank for platform-wide prompts.")
    active: Optional[StrictBool] = Field(default=True, description="Whether this prompt is currently active")
    __properties: ClassVar[List[str]] = ["platform_key", "prompt_text", "recommendation_type", "spa_url", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlatformPrompt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if spa_url (nullable) is None
        # and model_fields_set contains the field
        if self.spa_url is None and "spa_url" in self.model_fields_set:
            _dict['spa_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlatformPrompt from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "platform_key": obj.get("platform_key"),
            "prompt_text": obj.get("prompt_text"),
            "recommendation_type": obj.get("recommendation_type"),
            "spa_url": obj.get("spa_url"),
            "active": obj.get("active") if obj.get("active") is not None else True
        })
        return _obj


