# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from iblai.models.top_content import TopContent
from typing import Optional, Set
from typing_extensions import Self

class PlatformSummary(BaseModel):
    """
    Serializer for platform summary data (cross-platform view).
    """ # noqa: E501
    enrollments: StrictInt
    programs: StrictInt
    pathways: StrictInt
    resources: StrictInt
    reported_skills: StrictInt
    desired_skills: StrictInt
    assigned_skills: StrictInt
    total_skills: StrictInt
    credentials: StrictInt
    points: Union[StrictFloat, StrictInt]
    first_activity: Optional[datetime]
    last_activity: Optional[datetime]
    total_time_spent_seconds: StrictInt = Field(description="Total time spent")
    top_content: TopContent = Field(description="Course with most time spent")
    __properties: ClassVar[List[str]] = ["enrollments", "programs", "pathways", "resources", "reported_skills", "desired_skills", "assigned_skills", "total_skills", "credentials", "points", "first_activity", "last_activity", "total_time_spent_seconds", "top_content"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlatformSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of top_content
        if self.top_content:
            _dict['top_content'] = self.top_content.to_dict()
        # set to None if first_activity (nullable) is None
        # and model_fields_set contains the field
        if self.first_activity is None and "first_activity" in self.model_fields_set:
            _dict['first_activity'] = None

        # set to None if last_activity (nullable) is None
        # and model_fields_set contains the field
        if self.last_activity is None and "last_activity" in self.model_fields_set:
            _dict['last_activity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlatformSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enrollments": obj.get("enrollments"),
            "programs": obj.get("programs"),
            "pathways": obj.get("pathways"),
            "resources": obj.get("resources"),
            "reported_skills": obj.get("reported_skills"),
            "desired_skills": obj.get("desired_skills"),
            "assigned_skills": obj.get("assigned_skills"),
            "total_skills": obj.get("total_skills"),
            "credentials": obj.get("credentials"),
            "points": obj.get("points"),
            "first_activity": obj.get("first_activity"),
            "last_activity": obj.get("last_activity"),
            "total_time_spent_seconds": obj.get("total_time_spent_seconds"),
            "top_content": TopContent.from_dict(obj["top_content"]) if obj.get("top_content") is not None else None
        })
        return _obj


