# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ProgramCompletion(BaseModel):
    """
    ProgramCompletion
    """ # noqa: E501
    completed: StrictBool
    completion_percentage: Optional[Union[StrictFloat, StrictInt]] = None
    passed: Optional[StrictBool] = None
    passed_date: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["completed", "completion_percentage", "passed", "passed_date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramCompletion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if completion_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.completion_percentage is None and "completion_percentage" in self.model_fields_set:
            _dict['completion_percentage'] = None

        # set to None if passed (nullable) is None
        # and model_fields_set contains the field
        if self.passed is None and "passed" in self.model_fields_set:
            _dict['passed'] = None

        # set to None if passed_date (nullable) is None
        # and model_fields_set contains the field
        if self.passed_date is None and "passed_date" in self.model_fields_set:
            _dict['passed_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramCompletion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "completed": obj.get("completed"),
            "completion_percentage": obj.get("completion_percentage"),
            "passed": obj.get("passed"),
            "passed_date": obj.get("passed_date")
        })
        return _obj


