# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ProgramEnrollment(BaseModel):
    """
    ProgramEnrollment
    """ # noqa: E501
    user_id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    program_id: Optional[StrictStr] = None
    program_key: Optional[StrictStr] = None
    platform_key: Optional[StrictStr] = None
    org: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    slug: Optional[StrictStr] = None
    created: Optional[datetime] = Field(default=None, description="Date when enrollment began/activated")
    started: Optional[datetime] = Field(default=None, description="Date when enrollment started")
    ended: Optional[datetime] = Field(description="Date when enrollment ended/deactivated")
    expired: Optional[datetime] = Field(default=None, description="Date when enrollment expires (null, if not expiring)")
    active: Optional[StrictBool] = Field(default=None, description="Whether the enrollment is active")
    __properties: ClassVar[List[str]] = ["user_id", "username", "program_id", "program_key", "platform_key", "org", "name", "slug", "created", "started", "ended", "expired", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramEnrollment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "ended",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if created (nullable) is None
        # and model_fields_set contains the field
        if self.created is None and "created" in self.model_fields_set:
            _dict['created'] = None

        # set to None if started (nullable) is None
        # and model_fields_set contains the field
        if self.started is None and "started" in self.model_fields_set:
            _dict['started'] = None

        # set to None if ended (nullable) is None
        # and model_fields_set contains the field
        if self.ended is None and "ended" in self.model_fields_set:
            _dict['ended'] = None

        # set to None if expired (nullable) is None
        # and model_fields_set contains the field
        if self.expired is None and "expired" in self.model_fields_set:
            _dict['expired'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramEnrollment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "program_id": obj.get("program_id"),
            "program_key": obj.get("program_key"),
            "platform_key": obj.get("platform_key"),
            "org": obj.get("org"),
            "name": obj.get("name"),
            "slug": obj.get("slug"),
            "created": obj.get("created"),
            "started": obj.get("started"),
            "ended": obj.get("ended"),
            "expired": obj.get("expired"),
            "active": obj.get("active")
        })
        return _obj


