# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ProgramInvitationDetail(BaseModel):
    """
    Response serializer for program invitation details
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the invitation")
    user_id: Optional[StrictInt] = Field(description="The ID of the user associated with the invitation")
    username: Optional[StrictStr] = Field(description="The username of the user associated with the invitation")
    email: Optional[StrictStr] = Field(description="The email address associated with the invitation")
    created: datetime = Field(description="When the invitation was created")
    started: Optional[datetime] = Field(description="When the invitation was started")
    expired: Optional[datetime] = Field(description="When the invitation expires")
    source: Optional[StrictStr] = Field(description="The source of the invitation")
    redirect_to: Optional[StrictStr] = Field(description="URL to redirect to after accepting the invitation")
    active: StrictBool = Field(description="Whether the invitation is active")
    metadata: Dict[str, Any] = Field(description="Additional metadata for the invitation")
    program_key: StrictStr = Field(description="The program key associated with the invitation")
    __properties: ClassVar[List[str]] = ["id", "user_id", "username", "email", "created", "started", "expired", "source", "redirect_to", "active", "metadata", "program_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramInvitationDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['user_id'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if started (nullable) is None
        # and model_fields_set contains the field
        if self.started is None and "started" in self.model_fields_set:
            _dict['started'] = None

        # set to None if expired (nullable) is None
        # and model_fields_set contains the field
        if self.expired is None and "expired" in self.model_fields_set:
            _dict['expired'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if redirect_to (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_to is None and "redirect_to" in self.model_fields_set:
            _dict['redirect_to'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramInvitationDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "created": obj.get("created"),
            "started": obj.get("started"),
            "expired": obj.get("expired"),
            "source": obj.get("source"),
            "redirect_to": obj.get("redirect_to"),
            "active": obj.get("active"),
            "metadata": obj.get("metadata"),
            "program_key": obj.get("program_key")
        })
        return _obj


