# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ProgramLicenseAssignmentDetail(BaseModel):
    """
    Response serializer for program license assignment details.  This serializer represents a program license assignment with all its attributes, including user information, license details, and assignment status.  Fields:     id: The unique identifier for the assignment     user_id: The ID of the user assigned the license (may be null for email-only assignments)     username: The username of the user assigned the license (may be null for email-only assignments)     name: The full name of the user assigned the license (may be null for email-only assignments)     email: The email address of the user assigned the license (may be null for user-only assignments)     active: Whether the assignment is active and valid     fulfilled: Whether the assignment has been processed/fulfilled     direct: Whether the assignment was directly assigned to the user (vs. via a group)     redirect_to: URL to redirect to after fulfillment     metadata: Additional metadata for the assignment     created: When the assignment was created     modified: When the assignment was last modified     license_id: The ID of the program license     license_name: The name of the program license     program_key: The program key associated with the license
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the assignment")
    user_id: Optional[StrictInt] = Field(description="The ID of the user assigned the license")
    username: Optional[StrictStr] = Field(description="The username of the user assigned the license")
    name: Optional[StrictStr] = Field(description="The full name of the user assigned the license")
    email: Optional[StrictStr] = Field(description="The email address of the user assigned the license")
    active: StrictBool = Field(description="Whether the assignment is active and valid")
    fulfilled: StrictBool = Field(description="Whether the assignment has been processed/fulfilled")
    direct: Optional[StrictBool] = Field(default=None, description="Whether the assignment was directly assigned to the user (vs. via a group)")
    redirect_to: Optional[StrictStr] = Field(default=None, description="URL to redirect to after fulfillment")
    metadata: Optional[Dict[str, Any]] = Field(description="Additional metadata for the assignment")
    created: Optional[datetime] = Field(default=None, description="When the assignment was created")
    modified: Optional[datetime] = Field(default=None, description="When the assignment was last modified")
    license_id: StrictInt = Field(description="The ID of the program license")
    license_name: StrictStr = Field(description="The name of the program license")
    program_key: StrictStr = Field(description="The program key associated with the license")
    __properties: ClassVar[List[str]] = ["id", "user_id", "username", "name", "email", "active", "fulfilled", "direct", "redirect_to", "metadata", "created", "modified", "license_id", "license_name", "program_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramLicenseAssignmentDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['user_id'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramLicenseAssignmentDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "active": obj.get("active"),
            "fulfilled": obj.get("fulfilled"),
            "direct": obj.get("direct"),
            "redirect_to": obj.get("redirect_to"),
            "metadata": obj.get("metadata"),
            "created": obj.get("created"),
            "modified": obj.get("modified"),
            "license_id": obj.get("license_id"),
            "license_name": obj.get("license_name"),
            "program_key": obj.get("program_key")
        })
        return _obj


