# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ProgramLicenseDetail(BaseModel):
    """
    Response serializer for program license details.  This serializer represents a program license with all its attributes, including basic license information, program details, and usage statistics.  Fields:     id: The unique identifier for the license     created: When the license was created     started: When the license becomes active     expired: When the license expires (null if no expiration)     name: The display name of the license     count: The number of seats purchased     active: Whether the license is active     metadata: Additional license metadata     source: The source identifier for the license     external_id: External identifier for the license (null if none)     platform_key: The platform key associated with the license     program_id: The program ID associated with the license     program_name: The name of the program associated with the license     usage_count: Number of assignments using this license     assignments: Assignment counts (if verbose mode is enabled)  Notes:     - The assignments field is only included when verbose=true in the request     - The expired field may be null if the license doesn't expire     - The external_id field may be null if not provided
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the license")
    created: datetime = Field(description="When the license was created")
    started: datetime = Field(description="When the license becomes active")
    expired: Optional[datetime] = Field(description="When the license expires (null if no expiration)")
    name: StrictStr = Field(description="The display name of the license")
    count: StrictInt = Field(description="The number of seats purchased")
    active: StrictBool = Field(description="Whether the license is active")
    metadata: Dict[str, Any] = Field(description="Additional license metadata")
    source: StrictStr = Field(description="The source identifier for the license")
    external_id: Optional[StrictStr] = Field(description="External identifier for the license (null if none)")
    platform_key: StrictStr = Field(description="The platform key associated with the license")
    program_id: Optional[StrictStr] = Field(default=None, description="The program ID associated with the license")
    program_key: Optional[StrictStr] = Field(default=None, description="The program key associated with the license")
    program_name: Optional[StrictStr] = Field(default=None, description="The name of the program associated with the license")
    usage_count: StrictInt = Field(description="Number of assignments using this license")
    assignments: Optional[Dict[str, StrictInt]] = Field(default=None, description="Assignment counts by status (only included in verbose mode)")
    __properties: ClassVar[List[str]] = ["id", "created", "started", "expired", "name", "count", "active", "metadata", "source", "external_id", "platform_key", "program_id", "program_key", "program_name", "usage_count", "assignments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramLicenseDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if expired (nullable) is None
        # and model_fields_set contains the field
        if self.expired is None and "expired" in self.model_fields_set:
            _dict['expired'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['external_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramLicenseDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "started": obj.get("started"),
            "expired": obj.get("expired"),
            "name": obj.get("name"),
            "count": obj.get("count"),
            "active": obj.get("active"),
            "metadata": obj.get("metadata"),
            "source": obj.get("source"),
            "external_id": obj.get("external_id"),
            "platform_key": obj.get("platform_key"),
            "program_id": obj.get("program_id"),
            "program_key": obj.get("program_key"),
            "program_name": obj.get("program_name"),
            "usage_count": obj.get("usage_count"),
            "assignments": obj.get("assignments")
        })
        return _obj


