# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ProgramLicenseGroupAssignmentDetail(BaseModel):
    """
    Response serializer for program license group assignment details.  This serializer represents a program license group assignment with all its attributes, including group information, license details, and assignment status.  Fields:     id: The unique identifier for the group assignment     group_id: The ID of the group assigned the license     group_name: The name of the group assigned the license     active: Whether the group assignment is active and valid     fulfilled: Whether the group assignment has been processed/fulfilled     redirect_to: URL to redirect to after fulfillment     metadata: Additional metadata for the group assignment     created: When the group assignment was created     modified: When the group assignment was last modified     license_id: The ID of the program license     license_name: The name of the program license     program_key: The program key associated with the license     program_name: The name of the program associated with the license     user_count: Number of users in the group     assigned_count: Number of users in the group who have been assigned the license
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the assignment")
    group_id: StrictInt = Field(description="The ID of the group assigned the license")
    group_name: StrictStr = Field(description="The name of the group assigned the license")
    active: StrictBool = Field(description="Whether the assignment is active and valid")
    fulfilled: StrictBool = Field(description="Whether the assignment has been processed/fulfilled")
    redirect_to: Optional[StrictStr] = Field(description="URL to redirect to after fulfillment")
    metadata: Optional[Dict[str, Any]] = Field(description="Additional metadata for the assignment")
    created: datetime = Field(description="When the assignment was created")
    modified: datetime = Field(description="When the assignment was last modified")
    license_id: StrictInt = Field(description="The ID of the program license")
    license_name: StrictStr = Field(description="The name of the program license")
    program_key: StrictStr = Field(description="The program key associated with the license")
    program_name: StrictStr = Field(description="The name of the program associated with the license")
    user_count: StrictInt = Field(description="Number of users in the group")
    assigned_count: StrictInt = Field(description="Number of users in the group who have been assigned the license")
    __properties: ClassVar[List[str]] = ["id", "group_id", "group_name", "active", "fulfilled", "redirect_to", "metadata", "created", "modified", "license_id", "license_name", "program_key", "program_name", "user_count", "assigned_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramLicenseGroupAssignmentDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if redirect_to (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_to is None and "redirect_to" in self.model_fields_set:
            _dict['redirect_to'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramLicenseGroupAssignmentDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "group_id": obj.get("group_id"),
            "group_name": obj.get("group_name"),
            "active": obj.get("active"),
            "fulfilled": obj.get("fulfilled"),
            "redirect_to": obj.get("redirect_to"),
            "metadata": obj.get("metadata"),
            "created": obj.get("created"),
            "modified": obj.get("modified"),
            "license_id": obj.get("license_id"),
            "license_name": obj.get("license_name"),
            "program_key": obj.get("program_key"),
            "program_name": obj.get("program_name"),
            "user_count": obj.get("user_count"),
            "assigned_count": obj.get("assigned_count")
        })
        return _obj


