# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ProgramReviewRequest(BaseModel):
    """
    Request serializer for ProgramReviewUpdateView POST endpoint.
    """ # noqa: E501
    program_key: StrictStr = Field(description="The program key to review (format: program-v1:org+program_id)")
    username: StrictStr = Field(description="The username of the reviewer")
    user_id: Optional[StrictInt] = Field(default=None, description="The user ID of the reviewer (alternative to username)")
    rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The rating value (typically 1-5)")
    title: Optional[StrictStr] = Field(default=None, description="The review title")
    content: Optional[StrictStr] = Field(default=None, description="The review content/text")
    visible: Optional[StrictBool] = Field(default=True, description="Whether the review is visible")
    metadata: Optional[Any] = Field(default=None, description="Additional review metadata")
    __properties: ClassVar[List[str]] = ["program_key", "username", "user_id", "rating", "title", "content", "visible", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramReviewRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['rating'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramReviewRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "program_key": obj.get("program_key"),
            "username": obj.get("username"),
            "user_id": obj.get("user_id"),
            "rating": obj.get("rating"),
            "title": obj.get("title"),
            "content": obj.get("content"),
            "visible": obj.get("visible") if obj.get("visible") is not None else True,
            "metadata": obj.get("metadata")
        })
        return _obj


