# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.program_course_position import ProgramCoursePosition
from typing import Optional, Set
from typing_extensions import Self

class ProgramSearch(BaseModel):
    """
    ProgramSearch
    """ # noqa: E501
    course_list: List[ProgramCoursePosition]
    program_id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="A unique program ID identifiable by edX.")
    program_key: StrictStr
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The verbose name of the program.")
    enabled: Optional[StrictBool] = Field(default=None, description="Select if this program should be enabled.")
    slug: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="An additional unique slug field. (Optional)")
    org: Optional[StrictStr] = None
    platform_key: StrictStr
    program_type: StrictStr
    data: Optional[Any] = Field(default=None, description="Metadata")
    __properties: ClassVar[List[str]] = ["course_list", "program_id", "program_key", "name", "enabled", "slug", "org", "platform_key", "program_type", "data"]

    @field_validator('slug')
    def slug_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[-a-zA-Z0-9_]+$", value):
            raise ValueError(r"must validate the regular expression /^[-a-zA-Z0-9_]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgramSearch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "program_key",
            "platform_key",
            "program_type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in course_list (list)
        _items = []
        if self.course_list:
            for _item_course_list in self.course_list:
                if _item_course_list:
                    _items.append(_item_course_list.to_dict())
            _dict['course_list'] = _items
        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgramSearch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "course_list": [ProgramCoursePosition.from_dict(_item) for _item in obj["course_list"]] if obj.get("course_list") is not None else None,
            "program_id": obj.get("program_id"),
            "program_key": obj.get("program_key"),
            "name": obj.get("name"),
            "enabled": obj.get("enabled"),
            "slug": obj.get("slug"),
            "org": obj.get("org"),
            "platform_key": obj.get("platform_key"),
            "program_type": obj.get("program_type"),
            "data": obj.get("data")
        })
        return _obj


