# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class Prompt(BaseModel):
    """
    Prompt
    """ # noqa: E501
    id: StrictInt
    mentor: Optional[UUID] = None
    tone: Optional[StrictStr] = None
    style: Optional[StrictStr] = None
    language: Optional[StrictStr] = None
    tags: Optional[List[StrictInt]] = None
    is_system: Optional[StrictBool] = True
    metadata: Optional[Any] = None
    category: Optional[StrictStr] = None
    prompt: StrictStr
    title: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    description: Optional[StrictStr] = None
    prompt_visibility: Optional[StrictStr] = None
    created_at: datetime
    updated_at: datetime
    created_by: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    platform: StrictInt
    __properties: ClassVar[List[str]] = ["id", "mentor", "tone", "style", "language", "tags", "is_system", "metadata", "category", "prompt", "title", "description", "prompt_visibility", "created_at", "updated_at", "created_by", "platform"]

    @field_validator('prompt_visibility')
    def prompt_visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['viewable_by_tenant_admins', 'viewable_by_tenant_students', 'viewable_by_anyone', '']):
            raise ValueError("must be one of enum values ('viewable_by_tenant_admins', 'viewable_by_tenant_students', 'viewable_by_anyone', '')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Prompt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "created_at",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tone (nullable) is None
        # and model_fields_set contains the field
        if self.tone is None and "tone" in self.model_fields_set:
            _dict['tone'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if prompt_visibility (nullable) is None
        # and model_fields_set contains the field
        if self.prompt_visibility is None and "prompt_visibility" in self.model_fields_set:
            _dict['prompt_visibility'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['created_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Prompt from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "mentor": obj.get("mentor"),
            "tone": obj.get("tone"),
            "style": obj.get("style"),
            "language": obj.get("language"),
            "tags": obj.get("tags"),
            "is_system": obj.get("is_system") if obj.get("is_system") is not None else True,
            "metadata": obj.get("metadata"),
            "category": obj.get("category"),
            "prompt": obj.get("prompt"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "prompt_visibility": obj.get("prompt_visibility"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "created_by": obj.get("created_by"),
            "platform": obj.get("platform")
        })
        return _obj


