# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.prompt import Prompt
from iblai.models.prompt_facet import PromptFacet
from typing import Optional, Set
from typing_extensions import Self

class PromptSearchResponse(BaseModel):
    """
    Response serializer for PromptSearchView
    """ # noqa: E501
    results: List[Prompt] = Field(description="List of prompts matching the search criteria")
    count: StrictInt = Field(description="Total number of prompts matching the search criteria")
    next: Optional[StrictStr] = Field(description="URL for the next page of results")
    previous: Optional[StrictStr] = Field(description="URL for the previous page of results")
    current_page: StrictInt = Field(description="Current page number")
    num_pages: StrictInt = Field(description="Total number of pages")
    facets: Optional[Dict[str, PromptFacet]] = Field(default=None, description="Facet information for filtering")
    __properties: ClassVar[List[str]] = ["results", "count", "next", "previous", "current_page", "num_pages", "facets"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PromptSearchResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item_results in self.results:
                if _item_results:
                    _items.append(_item_results.to_dict())
            _dict['results'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in facets (dict)
        _field_dict = {}
        if self.facets:
            for _key_facets in self.facets:
                if self.facets[_key_facets]:
                    _field_dict[_key_facets] = self.facets[_key_facets].to_dict()
            _dict['facets'] = _field_dict
        # set to None if next (nullable) is None
        # and model_fields_set contains the field
        if self.next is None and "next" in self.model_fields_set:
            _dict['next'] = None

        # set to None if previous (nullable) is None
        # and model_fields_set contains the field
        if self.previous is None and "previous" in self.model_fields_set:
            _dict['previous'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PromptSearchResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "results": [Prompt.from_dict(_item) for _item in obj["results"]] if obj.get("results") is not None else None,
            "count": obj.get("count"),
            "next": obj.get("next"),
            "previous": obj.get("previous"),
            "current_page": obj.get("current_page"),
            "num_pages": obj.get("num_pages"),
            "facets": dict(
                (_k, PromptFacet.from_dict(_v))
                for _k, _v in obj["facets"].items()
            )
            if obj.get("facets") is not None
            else None
        })
        return _obj


