# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.input_question import InputQuestion
from typing import Optional, Set
from typing_extensions import Self

class QuestionRequest(BaseModel):
    """
    Serializer for incoming request data that includes initial questions and the username.  Attributes:     username (str): Username of the requesting student or user.     initial_questions (list[InputQuestionSerializer]): List of initial questions provided by the LMS.     question_count (int): Number of questions the mentor (llm) should generate
    """ # noqa: E501
    username: Annotated[str, Field(strict=True, max_length=100)]
    initial_questions: List[InputQuestion]
    question_count: Optional[StrictInt] = 20
    subject: Annotated[str, Field(strict=True, max_length=100)]
    __properties: ClassVar[List[str]] = ["username", "initial_questions", "question_count", "subject"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QuestionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in initial_questions (list)
        _items = []
        if self.initial_questions:
            for _item_initial_questions in self.initial_questions:
                if _item_initial_questions:
                    _items.append(_item_initial_questions.to_dict())
            _dict['initial_questions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QuestionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "initial_questions": [InputQuestion.from_dict(_item) for _item in obj["initial_questions"]] if obj.get("initial_questions") is not None else None,
            "question_count": obj.get("question_count") if obj.get("question_count") is not None else 20,
            "subject": obj.get("subject")
        })
        return _obj


