# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.rbac_base_role import RbacBaseRole
from iblai.models.rbac_platform import RbacPlatform
from iblai.models.rbac_policy_group import RbacPolicyGroup
from iblai.models.rbac_user import RbacUser
from typing import Optional, Set
from typing_extensions import Self

class RbacPolicy(BaseModel):
    """
    Serializer for policies.
    """ # noqa: E501
    id: StrictInt
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Policy name. If not supplied, defaults to a UUID4")
    role: RbacBaseRole = Field(description="Role information (read-only)")
    platform: RbacPlatform = Field(description="Platform information (read-only)")
    resources: List[StrictStr] = Field(description="List of resource paths this policy grants access to (e.g., ['/platforms/1/mentors', '/platforms/1/mentors/settings'])")
    users: List[RbacUser]
    groups: List[RbacPolicyGroup]
    role_id: StrictInt = Field(description="ID of the role this policy applies to")
    platform_key: StrictStr = Field(description="Platform key where this policy applies")
    users_to_add: Optional[List[StrictInt]] = Field(default=None, description="List of user IDs to add to this Policy")
    users_to_remove: Optional[List[StrictInt]] = Field(default=None, description="List of user IDs to remove from this Policy")
    groups_to_add: Optional[List[StrictInt]] = Field(default=None, description="List of group IDs to add to this Policy")
    groups_to_remove: Optional[List[StrictInt]] = Field(default=None, description="List of group IDs to remove from this Policy")
    is_internal: StrictBool = Field(description="When True, this policy is internal to the system and cannot be viewed or modified by tenants via API endpoints.")
    __properties: ClassVar[List[str]] = ["id", "name", "role", "platform", "resources", "users", "groups", "role_id", "platform_key", "users_to_add", "users_to_remove", "groups_to_add", "groups_to_remove", "is_internal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RbacPolicy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "role",
            "platform",
            "users",
            "groups",
            "is_internal",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of role
        if self.role:
            _dict['role'] = self.role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RbacPolicy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "role": RbacBaseRole.from_dict(obj["role"]) if obj.get("role") is not None else None,
            "platform": RbacPlatform.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "resources": obj.get("resources"),
            "users": [RbacUser.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "groups": [RbacPolicyGroup.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "role_id": obj.get("role_id"),
            "platform_key": obj.get("platform_key"),
            "users_to_add": obj.get("users_to_add"),
            "users_to_remove": obj.get("users_to_remove"),
            "groups_to_add": obj.get("groups_to_add"),
            "groups_to_remove": obj.get("groups_to_remove"),
            "is_internal": obj.get("is_internal")
        })
        return _obj


