# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.rbac_platform import RbacPlatform
from typing import Optional, Set
from typing_extensions import Self

class RbacRole(BaseModel):
    """
    Serializer for roles.
    """ # noqa: E501
    id: StrictInt
    name: Annotated[str, Field(strict=True, max_length=255)]
    platform: RbacPlatform = Field(description="Platform information (read-only)")
    platform_key: StrictStr = Field(description="Platform key where this role belongs")
    actions: Optional[List[StrictStr]] = Field(default=None, description="List of actions/permissions this role can perform (e.g., ['Ibl.Mentor/Settings/read', 'Ibl.Mentor/Settings/write'])")
    data_actions: Optional[List[StrictStr]] = Field(default=None, description="List of data actions/permissions this role can perform for field-level access (e.g., ['Ibl.Mentor/Settings/name/read', 'Ibl.Mentor/Settings/email/write'])")
    is_internal: StrictBool = Field(description="When True, this role is internal to the system and cannot be viewed or modified by tenants via API endpoints.")
    __properties: ClassVar[List[str]] = ["id", "name", "platform", "platform_key", "actions", "data_actions", "is_internal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RbacRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform",
            "is_internal",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RbacRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "platform": RbacPlatform.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "platform_key": obj.get("platform_key"),
            "actions": obj.get("actions"),
            "data_actions": obj.get("data_actions"),
            "is_internal": obj.get("is_internal")
        })
        return _obj


