# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class RecentlyAccessedMentor(BaseModel):
    """
    RecentlyAccessedMentor
    """ # noqa: E501
    id: Optional[StrictInt]
    unique_id: Optional[UUID]
    slug: Optional[StrictStr]
    name: Optional[StrictStr]
    description: Optional[StrictStr]
    recently_accessed_at: Optional[StrictStr]
    platform_key: Optional[StrictStr]
    last_accessed_by: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "unique_id", "slug", "name", "description", "recently_accessed_at", "platform_key", "last_accessed_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecentlyAccessedMentor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "unique_id",
            "slug",
            "name",
            "description",
            "recently_accessed_at",
            "platform_key",
            "last_accessed_by",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['unique_id'] = None

        # set to None if slug (nullable) is None
        # and model_fields_set contains the field
        if self.slug is None and "slug" in self.model_fields_set:
            _dict['slug'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if recently_accessed_at (nullable) is None
        # and model_fields_set contains the field
        if self.recently_accessed_at is None and "recently_accessed_at" in self.model_fields_set:
            _dict['recently_accessed_at'] = None

        # set to None if platform_key (nullable) is None
        # and model_fields_set contains the field
        if self.platform_key is None and "platform_key" in self.model_fields_set:
            _dict['platform_key'] = None

        # set to None if last_accessed_by (nullable) is None
        # and model_fields_set contains the field
        if self.last_accessed_by is None and "last_accessed_by" in self.model_fields_set:
            _dict['last_accessed_by'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecentlyAccessedMentor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "unique_id": obj.get("unique_id"),
            "slug": obj.get("slug"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "recently_accessed_at": obj.get("recently_accessed_at"),
            "platform_key": obj.get("platform_key"),
            "last_accessed_by": obj.get("last_accessed_by")
        })
        return _obj


