# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ReportRequest(BaseModel):
    """
    ReportRequest
    """ # noqa: E501
    report_name: Optional[StrictStr] = Field(default=None, description="Report slug, this is passed when calling the create report endpoint")
    start_date: Optional[date] = Field(default=None, description="Start date for the report")
    end_date: Optional[date] = Field(default=None, description="End date for the report")
    mentor: Optional[StrictStr] = Field(default=None, description="Mentor ID for the report (Only for mentor reports)")
    course_id: Optional[StrictStr] = Field(default=None, description="Course ID for the report (Only for course reports)")
    query: Optional[StrictStr] = Field(default=None, description=" Advanced Query to run the report, supports SQL Like queries. This runs against the final result after all filters are applied.  e.g For date type filtering  date_joined > '2021-01-01'   See https://pandas.pydata.org/docs/reference/api/pandas.DataFrame.query.html#pandas.DataFrame.query         ")
    __properties: ClassVar[List[str]] = ["report_name", "start_date", "end_date", "mentor", "course_id", "query"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "report_name": obj.get("report_name"),
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date"),
            "mentor": obj.get("mentor"),
            "course_id": obj.get("course_id"),
            "query": obj.get("query")
        })
        return _obj


