# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.state_enum import StateEnum
from typing import Optional, Set
from typing_extensions import Self

class ReportStatus(BaseModel):
    """
    ReportStatus
    """ # noqa: E501
    report_id: Optional[StrictStr] = Field(default=None, description="Used to download the report")
    report_name: Optional[StrictStr] = Field(default=None, description="Report slug, this is passed when calling the create report endpoint")
    state: Optional[StateEnum] = Field(default=None, description="Report States  * `pending` - Pending * `running` - Running * `accumulating` - Accumulating * `processing` - Processing * `storing` - Storing * `completed` - Completed * `cancelled` - Cancelled * `error` - Error * `expired` - Expired")
    started_on: Optional[StrictStr] = Field(default=None, description="Report request timestamp (ISO 8601)")
    owner: Optional[StrictStr] = Field(default=None, description="Report Owner")
    expires: Optional[StrictStr] = Field(default=None, description="When report would expire and not available for download anymore")
    url: Optional[StrictStr] = Field(default=None, description="Download link for report when available")
    __properties: ClassVar[List[str]] = ["report_id", "report_name", "state", "started_on", "owner", "expires", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReportStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReportStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "report_id": obj.get("report_id"),
            "report_name": obj.get("report_name"),
            "state": obj.get("state"),
            "started_on": obj.get("started_on"),
            "owner": obj.get("owner"),
            "expires": obj.get("expires"),
            "url": obj.get("url")
        })
        return _obj


