# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ResourceCompletionRequest(BaseModel):
    """
    Request serializer for ResourceCompletionManagementView POST endpoint.
    """ # noqa: E501
    resource_id: StrictInt = Field(description="The unique identifier for the resource")
    user_id: StrictInt = Field(description="The ID of the user")
    completed: Optional[StrictBool] = Field(default=None, description="Whether the resource is completed")
    completion_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage of completion (0.0-1.0)")
    completion_date: Optional[datetime] = Field(default=None, description="When the resource was completed")
    completion_data: Optional[Any] = Field(default=None, description="Additional completion metadata")
    __properties: ClassVar[List[str]] = ["resource_id", "user_id", "completed", "completion_percentage", "completion_date", "completion_data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResourceCompletionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if completion_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.completion_percentage is None and "completion_percentage" in self.model_fields_set:
            _dict['completion_percentage'] = None

        # set to None if completion_date (nullable) is None
        # and model_fields_set contains the field
        if self.completion_date is None and "completion_date" in self.model_fields_set:
            _dict['completion_date'] = None

        # set to None if completion_data (nullable) is None
        # and model_fields_set contains the field
        if self.completion_data is None and "completion_data" in self.model_fields_set:
            _dict['completion_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResourceCompletionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resource_id": obj.get("resource_id"),
            "user_id": obj.get("user_id"),
            "completed": obj.get("completed"),
            "completion_percentage": obj.get("completion_percentage"),
            "completion_date": obj.get("completion_date"),
            "completion_data": obj.get("completion_data")
        })
        return _obj


