# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ResourceCreateUpdate(BaseModel):
    """
    ResourceCreateUpdate
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Resource ID for updates")
    user_id: Optional[StrictInt] = Field(default=None, description="User ID of the resource owner")
    username: Optional[StrictStr] = Field(default=None, description="Username of the resource owner")
    resource_type: StrictStr = Field(description="Type of resource (e.g., video, document)")
    url: StrictStr = Field(description="URL of the resource")
    name: StrictStr = Field(description="Name of the resource")
    description: Optional[StrictStr] = Field(default=None, description="Description of the resource")
    skills: Optional[List[StrictStr]] = Field(default=None, description="List of skill names associated with the resource")
    image: Optional[StrictStr] = Field(default=None, description="Image file")
    data: Optional[Any] = Field(default=None, description="Additional metadata for the resource")
    __properties: ClassVar[List[str]] = ["id", "user_id", "username", "resource_type", "url", "name", "description", "skills", "image", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResourceCreateUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResourceCreateUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "resource_type": obj.get("resource_type"),
            "url": obj.get("url"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "skills": obj.get("skills"),
            "image": obj.get("image"),
            "data": obj.get("data")
        })
        return _obj


