# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RetrieverDocumentEmbedding(BaseModel):
    """
    RetrieverDocumentEmbedding
    """ # noqa: E501
    id: StrictInt
    metadata: Optional[Any] = None
    document_name: Optional[StrictStr] = None
    document_type: Optional[StrictStr] = None
    username: StrictStr
    training_status: Optional[StrictStr] = None
    pathway: StrictStr
    url: Optional[StrictStr] = None
    tokens: Optional[StrictInt] = None
    platform_key: StrictStr
    is_trained: Optional[StrictBool] = None
    access: Optional[StrictStr] = None
    crawler_max_depth: Optional[StrictInt] = None
    crawler_max_pages_limit: Optional[StrictInt] = None
    crawler_max_concurrency: Optional[StrictInt] = None
    crawler_match_patterns: Optional[Any] = Field(default=None, description="List of patterns that the crawler should use to match urls.          Patterns may be a glob pattern or a full regex pattern.          Indicate the specified type in `crawler_pattern_type`.")
    crawler_pattern_type: Optional[StrictStr] = None
    last_trained_at: Optional[datetime]
    __properties: ClassVar[List[str]] = ["id", "metadata", "document_name", "document_type", "username", "training_status", "pathway", "url", "tokens", "platform_key", "is_trained", "access", "crawler_max_depth", "crawler_max_pages_limit", "crawler_max_concurrency", "crawler_match_patterns", "crawler_pattern_type", "last_trained_at"]

    @field_validator('training_status')
    def training_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['trained', 'failed', 'pending', 'untrained', '']):
            raise ValueError("must be one of enum values ('trained', 'failed', 'pending', 'untrained', '')")
        return value

    @field_validator('access')
    def access_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private', '']):
            raise ValueError("must be one of enum values ('public', 'private', '')")
        return value

    @field_validator('crawler_pattern_type')
    def crawler_pattern_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['glob', 'regex', '']):
            raise ValueError("must be one of enum values ('glob', 'regex', '')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RetrieverDocumentEmbedding from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "last_trained_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if document_name (nullable) is None
        # and model_fields_set contains the field
        if self.document_name is None and "document_name" in self.model_fields_set:
            _dict['document_name'] = None

        # set to None if document_type (nullable) is None
        # and model_fields_set contains the field
        if self.document_type is None and "document_type" in self.model_fields_set:
            _dict['document_type'] = None

        # set to None if training_status (nullable) is None
        # and model_fields_set contains the field
        if self.training_status is None and "training_status" in self.model_fields_set:
            _dict['training_status'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if tokens (nullable) is None
        # and model_fields_set contains the field
        if self.tokens is None and "tokens" in self.model_fields_set:
            _dict['tokens'] = None

        # set to None if access (nullable) is None
        # and model_fields_set contains the field
        if self.access is None and "access" in self.model_fields_set:
            _dict['access'] = None

        # set to None if crawler_max_depth (nullable) is None
        # and model_fields_set contains the field
        if self.crawler_max_depth is None and "crawler_max_depth" in self.model_fields_set:
            _dict['crawler_max_depth'] = None

        # set to None if crawler_max_pages_limit (nullable) is None
        # and model_fields_set contains the field
        if self.crawler_max_pages_limit is None and "crawler_max_pages_limit" in self.model_fields_set:
            _dict['crawler_max_pages_limit'] = None

        # set to None if crawler_max_concurrency (nullable) is None
        # and model_fields_set contains the field
        if self.crawler_max_concurrency is None and "crawler_max_concurrency" in self.model_fields_set:
            _dict['crawler_max_concurrency'] = None

        # set to None if crawler_match_patterns (nullable) is None
        # and model_fields_set contains the field
        if self.crawler_match_patterns is None and "crawler_match_patterns" in self.model_fields_set:
            _dict['crawler_match_patterns'] = None

        # set to None if last_trained_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_trained_at is None and "last_trained_at" in self.model_fields_set:
            _dict['last_trained_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RetrieverDocumentEmbedding from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "document_name": obj.get("document_name"),
            "document_type": obj.get("document_type"),
            "username": obj.get("username"),
            "training_status": obj.get("training_status"),
            "pathway": obj.get("pathway"),
            "url": obj.get("url"),
            "tokens": obj.get("tokens"),
            "platform_key": obj.get("platform_key"),
            "is_trained": obj.get("is_trained"),
            "access": obj.get("access"),
            "crawler_max_depth": obj.get("crawler_max_depth"),
            "crawler_max_pages_limit": obj.get("crawler_max_pages_limit"),
            "crawler_max_concurrency": obj.get("crawler_max_concurrency"),
            "crawler_match_patterns": obj.get("crawler_match_patterns"),
            "crawler_pattern_type": obj.get("crawler_pattern_type"),
            "last_trained_at": obj.get("last_trained_at")
        })
        return _obj


