# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.access_enum import AccessEnum
from iblai.models.crawler_pattern_type_enum import CrawlerPatternTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class RetrieverDocumentEmbeddingRequest(BaseModel):
    """
    RetrieverDocumentEmbeddingRequest
    """ # noqa: E501
    document_name: Optional[StrictStr] = Field(default=None, description="The name of the document")
    document_type: Optional[StrictStr] = Field(default=None, description="The type of the document")
    pathway: StrictStr = Field(description="The pathway to retrain the document in")
    url: Optional[StrictStr] = Field(default=None, description="The url of the document")
    train: Optional[StrictBool] = Field(default=None, description="The type of the document")
    crawler_max_depth: Optional[StrictInt] = Field(default=None, description="The max depth of the crawler")
    crawler_max_pages_limit: Optional[StrictInt] = Field(default=None, description="The max pages limit of the crawler")
    crawler_max_concurrency: Optional[StrictInt] = Field(default=None, description="The max concurrency of the crawler")
    crawler_match_patterns: Optional[List[StrictStr]] = Field(default=None, description="The patterns that the crawler should use to match urls. Patterns may be a glob pattern or a full regex pattern. Indicate the specified type in `crawler_pattern_type`.")
    crawler_pattern_type: Optional[CrawlerPatternTypeEnum] = Field(default=None, description="Pattern type for the crawler  * `glob` - Glob * `regex` - Regex")
    access: Optional[AccessEnum] = Field(default=None, description="The access of the document.  * `public` - Public * `private` - Private")
    google_drive_auth_data: Optional[Any] = Field(default=None, description="Authentication and scoped details of google drive.")
    dropbox_auth_data: Optional[Any] = Field(default=None, description="Authentication and scoped details of dropbox")
    custom_metadata: Optional[Any] = Field(default=None, description="Custom metadata to attach to the trained document. Must be a flat JSON object with string keys and string, number, or boolean values.")
    __properties: ClassVar[List[str]] = ["document_name", "document_type", "pathway", "url", "train", "crawler_max_depth", "crawler_max_pages_limit", "crawler_max_concurrency", "crawler_match_patterns", "crawler_pattern_type", "access", "google_drive_auth_data", "dropbox_auth_data", "custom_metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RetrieverDocumentEmbeddingRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if train (nullable) is None
        # and model_fields_set contains the field
        if self.train is None and "train" in self.model_fields_set:
            _dict['train'] = None

        # set to None if google_drive_auth_data (nullable) is None
        # and model_fields_set contains the field
        if self.google_drive_auth_data is None and "google_drive_auth_data" in self.model_fields_set:
            _dict['google_drive_auth_data'] = None

        # set to None if dropbox_auth_data (nullable) is None
        # and model_fields_set contains the field
        if self.dropbox_auth_data is None and "dropbox_auth_data" in self.model_fields_set:
            _dict['dropbox_auth_data'] = None

        # set to None if custom_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.custom_metadata is None and "custom_metadata" in self.model_fields_set:
            _dict['custom_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RetrieverDocumentEmbeddingRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document_name": obj.get("document_name"),
            "document_type": obj.get("document_type"),
            "pathway": obj.get("pathway"),
            "url": obj.get("url"),
            "train": obj.get("train"),
            "crawler_max_depth": obj.get("crawler_max_depth"),
            "crawler_max_pages_limit": obj.get("crawler_max_pages_limit"),
            "crawler_max_concurrency": obj.get("crawler_max_concurrency"),
            "crawler_match_patterns": obj.get("crawler_match_patterns"),
            "crawler_pattern_type": obj.get("crawler_pattern_type"),
            "access": obj.get("access"),
            "google_drive_auth_data": obj.get("google_drive_auth_data"),
            "dropbox_auth_data": obj.get("dropbox_auth_data"),
            "custom_metadata": obj.get("custom_metadata")
        })
        return _obj


