# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.scim_meta import SCIMMeta
from typing import Optional, Set
from typing_extensions import Self

class SCIMGroup(BaseModel):
    """
    SCIM group serializer for RBAC group management
    """ # noqa: E501
    schemas: Optional[List[StrictStr]] = Field(default=None, description="SCIM schema identifiers")
    id: StrictStr = Field(description="RBAC group unique ID (must match existing RBAC group)")
    display_name: StrictStr = Field(description="RBAC group display name", alias="displayName")
    description: Optional[StrictStr] = Field(default=None, description="RBAC group description")
    members: Optional[List[Dict[str, Any]]] = Field(default=None, description="Users to add/remove from the RBAC group")
    meta: Optional[SCIMMeta] = Field(default=None, description="Resource metadata")
    __properties: ClassVar[List[str]] = ["schemas", "id", "displayName", "description", "members", "meta"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SCIMGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SCIMGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemas": obj.get("schemas"),
            "id": obj.get("id"),
            "displayName": obj.get("displayName"),
            "description": obj.get("description"),
            "members": obj.get("members"),
            "meta": SCIMMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


