# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SCIMGroupListResponse(BaseModel):
    """
    SCIM group list response serializer
    """ # noqa: E501
    schemas: List[StrictStr] = Field(description="SCIM schema identifiers")
    total_results: StrictInt = Field(description="Total number of results", alias="totalResults")
    resources: List[Dict[str, Any]] = Field(description="List of group resources", alias="Resources")
    start_index: Optional[StrictInt] = Field(default=None, description="Starting index", alias="startIndex")
    items_per_page: Optional[StrictInt] = Field(default=None, description="Items per page", alias="itemsPerPage")
    __properties: ClassVar[List[str]] = ["schemas", "totalResults", "Resources", "startIndex", "itemsPerPage"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SCIMGroupListResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SCIMGroupListResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemas": obj.get("schemas"),
            "totalResults": obj.get("totalResults"),
            "Resources": obj.get("Resources"),
            "startIndex": obj.get("startIndex"),
            "itemsPerPage": obj.get("itemsPerPage")
        })
        return _obj


