# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.scim_address import SCIMAddress
from iblai.models.scim_email import SCIMEmail
from iblai.models.scim_meta import SCIMMeta
from iblai.models.scim_name import SCIMName
from iblai.models.scim_phone_number import SCIMPhoneNumber
from typing import Optional, Set
from typing_extensions import Self

class SCIMUserCreateRequest(BaseModel):
    """
    SCIM user creation request serializer
    """ # noqa: E501
    schemas: Optional[List[StrictStr]] = Field(default=None, description="SCIM schema identifiers")
    user_name: StrictStr = Field(description="Unique username/email for the user", alias="userName")
    name: SCIMName = Field(description="User's name information")
    emails: List[SCIMEmail] = Field(description="User's email addresses")
    active: Optional[StrictBool] = Field(default=True, description="Whether the user is active")
    display_name: Optional[StrictStr] = Field(default=None, description="Display name", alias="displayName")
    locale: Optional[StrictStr] = Field(default=None, description="User locale")
    timezone: Optional[StrictStr] = Field(default=None, description="User timezone")
    title: Optional[StrictStr] = Field(default=None, description="Job title")
    organization: Optional[StrictStr] = Field(default=None, description="Organization")
    phone_numbers: Optional[List[SCIMPhoneNumber]] = Field(default=None, description="Phone numbers", alias="phoneNumbers")
    addresses: Optional[List[SCIMAddress]] = Field(default=None, description="Addresses")
    entitlements: Optional[List[StrictStr]] = Field(default=None, description="User entitlements")
    roles: Optional[List[StrictStr]] = Field(default=None, description="User roles")
    x509_certificates: Optional[List[StrictStr]] = Field(default=None, description="X.509 certificates", alias="x509Certificates")
    password: Optional[StrictStr] = Field(default=None, description="User password")
    provider: Optional[StrictStr] = Field(default=None, description="Authentication provider")
    tpa_uid: Optional[StrictStr] = Field(default=None, description="Third-party authentication UID", alias="tpaUid")
    is_staff: Optional[StrictBool] = Field(default=False, description="Whether the user is a staff member", alias="isStaff")
    update: Optional[StrictBool] = Field(default=False, description="Whether to update existing user")
    platform_orgs: Optional[List[StrictStr]] = Field(default=None, description="List of platform organizations to link the user to", alias="platformOrgs")
    department_ids: Optional[List[StrictInt]] = Field(default=None, description="List of department IDs to make the user a member of", alias="departmentIds")
    group_ids: Optional[List[StrictInt]] = Field(default=None, description="List of group IDs to add the user to", alias="groupIds")
    rbac_group_unique_ids: Optional[List[StrictStr]] = Field(default=None, description="List of RBAC group unique IDs to add the user to", alias="rbacGroupUniqueIds")
    meta: Optional[SCIMMeta] = Field(default=None, description="Resource metadata")
    __properties: ClassVar[List[str]] = ["schemas", "userName", "name", "emails", "active", "displayName", "locale", "timezone", "title", "organization", "phoneNumbers", "addresses", "entitlements", "roles", "x509Certificates", "password", "provider", "tpaUid", "isStaff", "update", "platformOrgs", "departmentIds", "groupIds", "rbacGroupUniqueIds", "meta"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SCIMUserCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in emails (list)
        _items = []
        if self.emails:
            for _item_emails in self.emails:
                if _item_emails:
                    _items.append(_item_emails.to_dict())
            _dict['emails'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in phone_numbers (list)
        _items = []
        if self.phone_numbers:
            for _item_phone_numbers in self.phone_numbers:
                if _item_phone_numbers:
                    _items.append(_item_phone_numbers.to_dict())
            _dict['phoneNumbers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in addresses (list)
        _items = []
        if self.addresses:
            for _item_addresses in self.addresses:
                if _item_addresses:
                    _items.append(_item_addresses.to_dict())
            _dict['addresses'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SCIMUserCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemas": obj.get("schemas"),
            "userName": obj.get("userName"),
            "name": SCIMName.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "emails": [SCIMEmail.from_dict(_item) for _item in obj["emails"]] if obj.get("emails") is not None else None,
            "active": obj.get("active") if obj.get("active") is not None else True,
            "displayName": obj.get("displayName"),
            "locale": obj.get("locale"),
            "timezone": obj.get("timezone"),
            "title": obj.get("title"),
            "organization": obj.get("organization"),
            "phoneNumbers": [SCIMPhoneNumber.from_dict(_item) for _item in obj["phoneNumbers"]] if obj.get("phoneNumbers") is not None else None,
            "addresses": [SCIMAddress.from_dict(_item) for _item in obj["addresses"]] if obj.get("addresses") is not None else None,
            "entitlements": obj.get("entitlements"),
            "roles": obj.get("roles"),
            "x509Certificates": obj.get("x509Certificates"),
            "password": obj.get("password"),
            "provider": obj.get("provider"),
            "tpaUid": obj.get("tpaUid"),
            "isStaff": obj.get("isStaff") if obj.get("isStaff") is not None else False,
            "update": obj.get("update") if obj.get("update") is not None else False,
            "platformOrgs": obj.get("platformOrgs"),
            "departmentIds": obj.get("departmentIds"),
            "groupIds": obj.get("groupIds"),
            "rbacGroupUniqueIds": obj.get("rbacGroupUniqueIds"),
            "meta": SCIMMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


