# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.scim_email import SCIMEmail
from iblai.models.scim_enterprise_user import SCIMEnterpriseUser
from iblai.models.scim_meta import SCIMMeta
from iblai.models.scim_name import SCIMName
from typing import Optional, Set
from typing_extensions import Self

class SCIMUserResponse(BaseModel):
    """
    SCIM user response serializer
    """ # noqa: E501
    schemas: List[StrictStr] = Field(description="SCIM schema identifiers")
    id: StrictStr = Field(description="User ID")
    user_name: StrictStr = Field(description="Username", alias="userName")
    name: SCIMName = Field(description="User's name information")
    emails: List[SCIMEmail] = Field(description="User's email addresses")
    active: StrictBool = Field(description="Whether the user is active")
    urn_ietf_params_scim_schemas_extension_enterprise_2_0_user: SCIMEnterpriseUser = Field(description="Enterprise user extension data", alias="urn_ietf_params_scim_schemas_extension_enterprise_2_0_User")
    meta: Optional[SCIMMeta] = Field(default=None, description="Resource metadata")
    __properties: ClassVar[List[str]] = ["schemas", "id", "userName", "name", "emails", "active", "urn_ietf_params_scim_schemas_extension_enterprise_2_0_User", "meta"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SCIMUserResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in emails (list)
        _items = []
        if self.emails:
            for _item_emails in self.emails:
                if _item_emails:
                    _items.append(_item_emails.to_dict())
            _dict['emails'] = _items
        # override the default output from pydantic by calling `to_dict()` of urn_ietf_params_scim_schemas_extension_enterprise_2_0_user
        if self.urn_ietf_params_scim_schemas_extension_enterprise_2_0_user:
            _dict['urn_ietf_params_scim_schemas_extension_enterprise_2_0_User'] = self.urn_ietf_params_scim_schemas_extension_enterprise_2_0_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SCIMUserResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemas": obj.get("schemas"),
            "id": obj.get("id"),
            "userName": obj.get("userName"),
            "name": SCIMName.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "emails": [SCIMEmail.from_dict(_item) for _item in obj["emails"]] if obj.get("emails") is not None else None,
            "active": obj.get("active"),
            "urn_ietf_params_scim_schemas_extension_enterprise_2_0_User": SCIMEnterpriseUser.from_dict(obj["urn_ietf_params_scim_schemas_extension_enterprise_2_0_User"]) if obj.get("urn_ietf_params_scim_schemas_extension_enterprise_2_0_User") is not None else None,
            "meta": SCIMMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


