# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Summary(BaseModel):
    """
    Summary metrics for the invoice.
    """ # noqa: E501
    total_cost: Annotated[str, Field(strict=True)]
    total_sessions: StrictInt
    active_users: StrictInt
    cost_per_session: Annotated[str, Field(strict=True)]
    __properties: ClassVar[List[str]] = ["total_cost", "total_sessions", "active_users", "cost_per_session"]

    @field_validator('total_cost')
    def total_cost_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^-?\d{0,9}(?:\.\d{0,3})?$", value):
            raise ValueError(r"must validate the regular expression /^-?\d{0,9}(?:\.\d{0,3})?$/")
        return value

    @field_validator('cost_per_session')
    def cost_per_session_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^-?\d{0,9}(?:\.\d{0,3})?$", value):
            raise ValueError(r"must validate the regular expression /^-?\d{0,9}(?:\.\d{0,3})?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Summary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Summary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total_cost": obj.get("total_cost"),
            "total_sessions": obj.get("total_sessions"),
            "active_users": obj.get("active_users"),
            "cost_per_session": obj.get("cost_per_session")
        })
        return _obj


